/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl.message;

import com.ebmwebsourcing.easyesb.component.bpel.impl.handler.ESBTerminationHandler;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ESBContextImpl implements ExternalContext {

	private Exchange   initialExchange;
	
	private ProviderEndpoint providerEndpoint;
		
	private TerminationHandler th = new ESBTerminationHandler();
	
	public ESBContextImpl(final Exchange exchange, final ProviderEndpoint providerEndpoint) {
		this.initialExchange = exchange;
		this.providerEndpoint = providerEndpoint;
	}
	
	public Exchange getInitialExchange() {
		return this.initialExchange;
	}

    public TerminationHandler getTerminationHandler() {
        return this.th;
    }

    public void setTerminationHandler(TerminationHandler th) {
        this.th = th;
    }
    
	public ProviderEndpoint getProviderEndpoint() {
		return providerEndpoint;
	}
}
