package com.ebmwebsourcing.easyesb.resources.endpoint;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;

@Scope("COMPOSITE")
@Service(value=CreationResourcesSubscriptionEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class CreationResourcesSubscriptionEndpointImpl<M extends ProviderEndpointType> extends ProviderEndpointImpl<M> implements CreationResourcesSubscriptionEndpoint<M> { 

	private Logger log = Logger.getLogger(CreationResourcesSubscriptionEndpointImpl.class.getName());
	
	private static final long serialVersionUID = 1L;
		
	public CreationResourcesSubscriptionEndpointImpl() {
		super();
	}
	
	public CreationResourcesSubscriptionEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}
	
	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ProviderEndpointType.class;
		}
		return res;
	}
}
