/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.resources.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.resources.endpoint.CreationResourcesSubscriptionEndpoint;
import com.ebmwebsourcing.easyesb.resources.endpoint.CreationResourcesSubscriptionEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;

public class CreationResourcesSubscriptionServiceBehaviourImpl extends ServiceBehaviourImpl implements CreationResourcesSubscriptionServiceBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(CreationResourcesSubscriptionServiceBehaviourImpl.class.getName());
	
	
	
	private CreationResourcesSubscriptionEndpoint<? extends ProviderEndpointType> creationResourcesSubscriptionEndpoint = null;
	
	
	public CreationResourcesSubscriptionServiceBehaviourImpl(CreationResourcesSubscriptionServiceImpl<? extends TechnicalServiceType> ep) {
		super(ep);
	}
	
	public void execute(Exchange exchange) throws TransportException {
		this.execute(exchange);
		
	}

	@SuppressWarnings("unchecked")
	public CreationResourcesSubscriptionEndpoint<? extends ProviderEndpointType> createCreationResourcesSubscriptionEndpoint(
			String name, EndpointInitialContext context) throws ESBException {
		if(this.creationResourcesSubscriptionEndpoint == null) {
			try {
				
				ProviderEndpointType model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint.class);
				model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
				model.getBehavioursList().addBehaviour(SubscriptionManagerEndpointBehaviourImpl.class.getName());
				model.getBehavioursList().addBehaviour(NotificationProducerEndpointBehaviourImpl.class.getName());
				model.setType(CreationResourcesSubscriptionEndpointImpl.class.getName());
				model.setEndpointInitialContext(context);
				model.setName(new QName(this.endpoint.getQName().getNamespaceURI(), name));
				model.setNode(this.getNodeQName());
				model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());
				model.setService(this.endpoint.getQName());

				
				// add service in registry
				if((this.getEndpoint().getNode() != null)&&(((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService() != null)) {
					boolean res = ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());
				
					if(res) {
						// get component
						creationResourcesSubscriptionEndpoint = (CreationResourcesSubscriptionEndpoint) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
					
						
//						adminEndpoint.addBehaviourClass(SubscriptionManagerEndpointBehaviourImpl.class);
//						adminEndpoint.addBehaviourClass(NotificationProducerEndpointBehaviourImpl.class);
//
						String topicDef = "" +
								"<wstop:TopicSet xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:tns1=\"http://www.petalslink.org/resources/event/1.0\" >\n" + 
								"    <tns1:CreationResourcesTopic wstop:topic=\"true\" />\n" + 
								"</wstop:TopicSet>\n";
						
						InputStream is = new ByteArrayInputStream(topicDef.getBytes());
						TopicSetType topicSet = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl()).getWstopReader().readTopicSetType(new InputSource(is));
						is.close();
						
						SubscriptionManagerEndpointBehaviour subscriptionManagerEndpointBehaviour = creationResourcesSubscriptionEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
						subscriptionManagerEndpointBehaviour.setEvenTopicNamespaceDefinitionUrl(Thread.currentThread().getContextClassLoader().getResource("topicnamespace/resources-events-topicsNS.xml"));
						subscriptionManagerEndpointBehaviour.setTopicSet(topicSet);

						final TopicsManagerEngine wstopTopicsMgr = new TopicsManagerEngine();
						final SubscriptionManagerEngine subscriptionManager = new SubscriptionManagerEngine(
								log);
						subscriptionManager.setSubscriptionsManagerService(this.getEndpointQName());    
						
						final NotificationProducerEngine producer = new NotificationProducerEngine(
								log, wstopTopicsMgr, subscriptionManager, true,
								subscriptionManagerEndpointBehaviour.getTopicSet(), subscriptionManagerEndpointBehaviour.getTopicNs(), "wsn", null /*this.notifSender*/);
						
						subscriptionManagerEndpointBehaviour.setSubscriptionManager(subscriptionManager);
						NotificationProducerEndpointBehaviour notificationProducerEndpointBehaviour = creationResourcesSubscriptionEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
						notificationProducerEndpointBehaviour.setNotificationProducer(producer);
						
						creationResourcesSubscriptionEndpoint.getNode().findBehaviour(NodeBehaviourImpl.class).getEndpointSubscribers().put(topicSet, (Endpoint<?>) creationResourcesSubscriptionEndpoint);
					}
				} else {
					throw new ESBException("Registry cannot be null"); 
				}
				
			} catch (RegistryFault_Exception e) {
				throw new ESBException(e);
			} catch (WsnbException e) {
				throw new ESBException(e);
			} catch (WstopException e) {
				throw new ESBException(e);
			} catch (IOException e) {
				throw new ESBException(e);
			} 
			log.fine("adminEndpoint " + name + " created and started");
		}
		return this.creationResourcesSubscriptionEndpoint;
	}

	public CreationResourcesSubscriptionEndpoint<? extends ProviderEndpointType> getCreationResourcesSubscriptionEndpoint() {
		return this.creationResourcesSubscriptionEndpoint;
	}






}
