/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl;

import com.ebmwebsourcing.easyesb.component.bpel.BpelComponentExtensionFactory;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.rawreport.RawReportExtensionFactory;
import com.ebmwebsourcing.easyesb.resources.CreationResourcesExtensionFactory;
import com.ebmwebsourcing.easyesb.soa.ESBKernelFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.AdminExtensionFactory;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceImpl;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ESBFactoryImpl
extends ESBKernelFactoryImpl
implements ESBFactory {
    private static Logger log = Logger.getLogger(ESBFactoryImpl.class.getName());
    private AdminEndpoint<?> adminEndpoint = null;
    private AdminExtensionFactory adminFactory = null;

    public Node createNode(QName name, Configuration conf) throws ESBException {
        Node node = this.createDefaultNode(name, conf);
        this.addSpecificElements(name, node, conf);
        return node;
    }

    public Node createDefaultNode(QName name, Configuration conf) throws ESBException {
        if (conf.getRegistryServiceClass() == null) {
            conf.setRegistryServiceClass(RegistryServiceImpl.class);
        }
        if (conf.getRegistryServiceBehaviourClass() == null) {
            conf.setRegistryServiceBehaviourClass(RegistryServiceBehaviourImpl.class);
        }
        Node node = super.createNode(name, conf);
        if (conf.getProperties().get("soap-external-port") != null) {
            log.finest("conf.getProperties().get(Configuration.SOAP_EXTERNAL_PORT) = " + (String)conf.getProperties().get("soap-external-port"));
            ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).addExternalServer((ExternalServer)new SoapServer(new SoapServerConfig(Integer.valueOf((String)conf.getProperties().get("soap-external-port")).intValue())));
        }
        this.adminFactory = new AdminExtensionFactory();
        this.adminFactory.addSpecificElements(name, node, conf);
        this.adminEndpoint = this.adminFactory.getAdminEndpoint();
        return node;
    }

    @Override
    public void addSpecificElements(QName name, Node node, Configuration conf) throws ESBException {
        new BpelComponentExtensionFactory().addSpecificElements(name, node, conf);
        new CreationResourcesExtensionFactory().addSpecificElements(name, node, conf);
        new RawReportExtensionFactory().addSpecificElements(name, node, conf);
        this.adminFactory.exposeAdminService(node);
    }

    @Override
    public AdminEndpoint<?> getAdminEndpoint() {
        return this.adminEndpoint;
    }
}

