package com.ebmwebsourcing.easyesb.cdk;

import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;

public class ESBHelper {

	
	
	public static URI createProviderEndpoint(Node<?> node, QName serviceName, String endpointName, Class<? extends EndpointBehaviour> behaviour) throws ESBException {
		Service<?> myService = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createService(serviceName, BusinessServiceImpl.class);
		ProviderEndpoint<?> pe = myService.findBehaviour(ServiceBehaviour.class).createProviderEndpoint(endpointName, ProviderEndpointImpl.class, behaviour, null, null);
		return pe.getReference();
	}
	
	
	public static ClientEndpoint<?> createClientEndpoint(Node<?> node, QName name) throws ESBException {
		@SuppressWarnings("unchecked")
		final ClientEndpoint<?> myClientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(name, ClientEndpointImpl.class, null, null, null);
		return myClientEndpoint;
	}

	public static Component<?> createComponent(Node<?> node, String name, Class<? extends ComponentBehaviour>... behaviours) throws ESBException {
		@SuppressWarnings("unchecked")
		final Component<?> myComponent = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(name, ComponentImpl.class);
		for(Class<? extends ComponentBehaviour> behaviour: behaviours) {
			myComponent.addBehaviourClass((Class<? extends EndpointBehaviour>) behaviour);	
		}
		return myComponent;
	}


	@SuppressWarnings("unchecked")
	public static String exposeAsWS(Node<?> node, ProviderEndpoint<?> ep) throws ESBException {
		try {
			SoapServer soapServer = (SoapServer) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
			if(soapServer == null) {
				throw new ESBException("Soap server cannot be null");
			}

			EndpointAddress addr = ESBUtil.analyzeURI(ep.getReference());
			String name = addr.getEndpointname();
			if(name == null) {
				name = addr.getServicename();
			}

			ListenerInitialisation listener = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ListenerInitialisation.class);
			listener.setClassName(SOAPListenerImpl.class.getName());
			listener.setServerName(soapServer.getName());

			@SuppressWarnings("rawtypes")
			ClientProxyEndpoint clientEndpoint = (ClientProxyEndpoint) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName(addr.getNamespace(), name + "ExternalEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, null, listener);
			clientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
			clientEndpoint.setProviderServiceName(new QName(addr.getNamespace(), addr.getServicename()));
			clientEndpoint.setProviderEndpointName(addr.getEndpointname());
			return clientEndpoint.getExternalListeners()[0].getExposedAddress();
		} catch (SOAException e) {
			throw new ESBException(e);
		}
	}
}
