/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.launcher.tasks;

import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.launcher.tasks.Task;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class InfoTask
extends Task {
    private Node node = null;

    public InfoTask(Node node) {
        this.node = node;
        this.setShortcut("i");
        this.setName("info");
        this.setDescription("Display the local container information");
    }

    @Override
    public int doProcess(List<String> args) {
        block18: {
            try {
                System.out.println("Infos");
                if (this.node != null) {
                    ExternalServer server2;
                    ArrayList<String> components = new ArrayList<String>();
                    ArrayList<String> services = new ArrayList<String>();
                    ArrayList<String> providerEndpoints = new ArrayList<String>();
                    ArrayList<String> clientEndpoints = new ArrayList<String>();
                    ArrayList<String> providerProxyEndpoints = new ArrayList<String>();
                    ArrayList<String> clientProxyEndpoints = new ArrayList<String>();
                    for (Endpoint ep : ((RegistryEndpointBehaviour)this.node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoints()) {
                        Object e = ep.getComponent().getFcInterface("service");
                        EndpointAddress addr = ESBUtil.analyzeURI((URI)ep.getReference());
                        if (e instanceof Component) {
                            components.add(addr.getServicename());
                            continue;
                        }
                        if (e instanceof Service) {
                            services.add(new QName(addr.getNamespace(), addr.getServicename()).toString());
                            continue;
                        }
                        if (e instanceof ProviderProxyEndpoint) {
                            providerProxyEndpoints.add("endpoint " + addr.getEndpointname() + " of service " + new QName(addr.getNamespace(), addr.getServicename()) + " is binded with service at " + ((ProviderProxyEndpoint)e).getExternalSenders()[0].getExternalAddress());
                            continue;
                        }
                        if (e instanceof ProviderEndpoint) {
                            providerEndpoints.add("endpoint " + addr.getEndpointname() + " of service " + new QName(addr.getNamespace(), addr.getServicename()));
                            continue;
                        }
                        if (e instanceof ClientProxyEndpoint) {
                            clientProxyEndpoints.add("endpoint " + new QName(addr.getNamespace(), addr.getEndpointname()) + " is exposed at " + ((ClientProxyEndpoint)e).getExternalListeners()[0].getExposedAddress());
                            continue;
                        }
                        if (!(e instanceof ClientEndpoint)) continue;
                        clientEndpoints.add("endpoint " + new QName(addr.getNamespace(), addr.getEndpointname()));
                    }
                    EndpointAddress addrReg = ESBUtil.analyzeURI((URI)this.node.getRegistryEndpoint().getReference());
                    services.add(new QName(addrReg.getNamespace(), addrReg.getServicename()).toString());
                    providerEndpoints.add("endpoint " + addrReg.getEndpointname() + " of service " + new QName(addrReg.getNamespace(), addrReg.getServicename()));
                    System.out.println("\n\n\nLocal composition of node: " + this.node.getQName());
                    System.out.println("--------------------------\n");
                    int port = -1;
                    Iterator i$ = ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).getExternalServers().iterator();
                    while (i$.hasNext() && (port = (server2 = (ExternalServer)i$.next()).getPort()) == -1) {
                    }
                    if (((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).getAdminExternalEndpoint() != null) {
                        System.out.println("External administration service available at: \n\t" + ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).getAdminExternalEndpoint());
                    }
                    System.out.println("\n\nServers:\n");
                    for (ExternalServer server2 : ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).getExternalServers()) {
                        System.out.println("\t- " + server2.getName());
                    }
                    System.out.println("\n\nComponents:\n");
                    for (String comp : components) {
                        System.out.println("\t- " + comp);
                    }
                    System.out.println("\n\nServices:\n");
                    for (String s : services) {
                        System.out.println("\t- " + s);
                    }
                    System.out.println("\n\nProvider Endpoints:\n");
                    for (String pep : providerEndpoints) {
                        System.out.println("\t- " + pep);
                    }
                    System.out.println("\n\nClient Endpoints:\n");
                    for (String cep : clientEndpoints) {
                        System.out.println("\t- " + cep);
                    }
                    System.out.println("\n\nProvider Proxy Endpoints:\n");
                    for (String pep : providerProxyEndpoints) {
                        System.out.println("\t- " + pep);
                    }
                    System.out.println("\n\nClient Proxy Endpoints:\n");
                    for (String cep : clientProxyEndpoints) {
                        System.out.println("\t- " + cep);
                    }
                    break block18;
                }
                throw new ESBException("node cannot be null");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return 1;
    }
}

