/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.api.type;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;

public interface ExchangeType extends XmlObject {


	QName getSource();

	void setSource(QName value);

	boolean hasSource();

	QName getDestination();

	void setDestination(QName value);

	boolean hasDestination();

	QName getServiceName();

	void setServiceName(QName value);

	boolean hasServiceName();

	QName getInterfaceName();

	void setInterfaceName(QName value);

	boolean hasInterfaceName();
	
	String getOperation();
	
	void setOperation(String value);

	boolean hasOperation();
	
	PatternType getPattern();

	void setPattern(PatternType value);

	boolean hasPattern();

	RoleType getRole();

	void setRole(RoleType value) ;

	boolean hasRole();

	StatusType getStatus();

	void setStatus(StatusType value);

	boolean hasStatus();

	MessageIn getMessageIn();

	void setMessageIn(MessageIn value);

	boolean hasMessageIn();

	MessageOut getMessageOut();

	void setMessageOut(MessageOut value);

	boolean hasMessageOut();
	
	MessageError getMessageError();
	
	void setMessageError(MessageError value);
	
	boolean hasMessageError();
	
	String getUuid();
	
	void setUuid(String value);
	
	boolean hasUuid();
}
