/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.exchange10.api.util;

import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class Util {
    public static InputStream convertDocumentToInputStream(Document doc) throws XmlObjectValidationException {
        ByteArrayInputStream inputStream = null;
        try {
            DOMSource source = new DOMSource(doc);
            StringWriter xmlAsWriter = new StringWriter();
            StreamResult result = new StreamResult(xmlAsWriter);
            TransformerFactory.newInstance().newTransformer().transform(source, result);
            inputStream = new ByteArrayInputStream(xmlAsWriter.toString().getBytes("UTF-8"));
        }
        catch (TransformerConfigurationException e) {
            throw new XmlObjectValidationException(e.getMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            throw new XmlObjectValidationException(e.getMessage(), (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XmlObjectValidationException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlObjectValidationException(e.getMessage(), (Throwable)e);
        }
        return inputStream;
    }
}

