/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.exchange10.api.type.ExchangeType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbExchangeType;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbPatternType;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbRoleType;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbStatusType;


class ExchangeTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbExchangeType> implements
ExchangeType {

	protected ExchangeTypeImpl(XmlContext xmlContext, EJaxbExchangeType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbExchangeType> getCompliantModelClass() {
		return EJaxbExchangeType.class;
	}


	@Override
	public QName getSource() {
		return this.getModelObject().getSource();
	}


	@Override
	public void setSource(QName value) {
		this.getModelObject().setSource(value);
	}


	@Override
	public boolean hasSource() {
		return this.getSource() != null;
	}


	@Override
	public QName getDestination() {
		return this.getModelObject().getDestination();
	}


	@Override
	public void setDestination(QName value) {
		this.getModelObject().setDestination(value);
	}


	@Override
	public boolean hasDestination() {
		return this.getDestination() != null;
	}


	@Override
	public QName getServiceName() {
		return this.getModelObject().getServiceName();
	}


	@Override
	public void setServiceName(QName value) {
		this.getModelObject().setServiceName(value);
	}


	@Override
	public boolean hasServiceName() {
		return this.getServiceName() != null;
	}


	@Override
	public QName getInterfaceName() {
		return this.getModelObject().getInterfaceName();
	}


	@Override
	public void setInterfaceName(QName value) {
		this.getModelObject().setInterfaceName(value);
	}


	@Override
	public boolean hasInterfaceName() {
		return this.getInterfaceName() != null;
	}


	@Override
	public String getOperation() {
		return this.getModelObject().getOperation();
	}


	@Override
	public void setOperation(String value) {
		this.getModelObject().setOperation(value);
	}


	@Override
	public boolean hasOperation() {
		return this.getOperation() != null;
	}


	@Override
	public PatternType getPattern() {
		if (getModelObject().getPattern() == null)
			return null;
		return PatternType.valueOf(getModelObject().getPattern().toString().toUpperCase());
	}


	@Override
	public void setPattern(PatternType value) {
		if (value == null) {
			getModelObject().setPattern(null);
		} else if (value.equals(PatternType.IN_ONLY)) {
			getModelObject().setPattern(EJaxbPatternType.IN_ONLY);
		} else {
			getModelObject().setPattern(EJaxbPatternType.IN_OUT);
		} 
	}


	@Override
	public boolean hasPattern() {
		return this.getPattern() != null;
	}


	@Override
	public RoleType getRole() {
		if (getModelObject().getRole() == null)
			return null;
		return RoleType.valueOf(getModelObject().getRole().toString().toUpperCase());
	}


	@Override
	public void setRole(RoleType value) {
		if (value == null) {
			getModelObject().setRole(null);
		} else if (value.equals(RoleType.CONSUMER)) {
			getModelObject().setRole(EJaxbRoleType.CONSUMER);
		} else {
			getModelObject().setRole(EJaxbRoleType.PROVIDER);
		} 
	}


	@Override
	public boolean hasRole() {
		return this.getRole() != null;
	}


	@Override
	public StatusType getStatus() {
		if (getModelObject().getStatus() == null)
			return null;
		return StatusType.valueOf(getModelObject().getStatus().toString().toUpperCase());
	}


	@Override
	public void setStatus(StatusType value) {
		if (value == null) {
			getModelObject().setStatus(null);
		} else if (value.equals(StatusType.ACTIVE)) {
			getModelObject().setStatus(EJaxbStatusType.ACTIVE);
		} else if (value.equals(StatusType.DONE)) {
			getModelObject().setStatus(EJaxbStatusType.DONE);
		} else {
			getModelObject().setStatus(EJaxbStatusType.FAULT);
		} 
	}


	@Override
	public boolean hasStatus() {
		return this.getStatus() != null;
	}


	@Override
	public MessageIn getMessageIn() {
		if(getModelObject().getMessageIn() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getMessageIn(), MessageIn.class);
		}
		return null;
	}


	@Override
	public void setMessageIn(MessageIn value) {
		setChild(value, MessageIn.class);
	}


	@Override
	public boolean hasMessageIn() {
		return this.getMessageIn() != null;
	}


	@Override
	public MessageOut getMessageOut() {
		if(getModelObject().getMessageOut() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getMessageOut(), MessageOut.class);
		}
		return null;	
	}


	@Override
	public void setMessageOut(MessageOut value) {
		setChild(value, MessageOut.class);
	}


	@Override
	public boolean hasMessageOut() {
		return this.getMessageOut() != null;
	}


	@Override
	public MessageError getMessageError() {
		if(getModelObject().getMessageError() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getMessageError(), MessageError.class);
		}
		return null;
	}


	@Override
	public void setMessageError(MessageError value) {
		setChild(value, MessageError.class);
	}


	@Override
	public boolean hasMessageError() {
		return this.getMessageError() != null;
	}


	@Override
	public String getUuid() {
		return this.getModelObject().getUuid();
	}


	@Override
	public void setUuid(String value) {
		this.getModelObject().setUuid(value);
	}


	@Override
	public boolean hasUuid() {
		return this.getUuid() != null;
	}



}
