/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.impl;



import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybox.api.ClassMetadataConstants;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.type.HeaderType;
import com.ebmwebsourcing.easyesb.exchange10.api.util.Util;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbHeaderType;


class HeaderTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbHeaderType> implements
HeaderType {

	protected HeaderTypeImpl(XmlContext xmlContext, EJaxbHeaderType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbHeaderType> getCompliantModelClass() {
		return EJaxbHeaderType.class;
	}


	@Override
	public Document[] getProperties() {
		List<Document> docs = new ArrayList<Document>();
		for(Object obj: this.getModelObject().getAny()) {
			docs.add(((Element)obj).getOwnerDocument());
		}
		return docs.toArray(new Document[docs.size()]);
	}


	@Override
	public void addProperty(Document doc) {
		if(doc != null) {
			Document d = (Document) doc.cloneNode(true);
			this.getModelObject().getAny().add(d.getDocumentElement());
		}
	}


	@Override
	public Document getProperty(QName name) {
		Document res = null;
		for(Object obj: this.getModelObject().getAny()) {
			QName elmtName = new QName(((Element)obj).getNamespaceURI(), ((Element)obj).getLocalName());
			if(elmtName.equals(name)) {
				res = ((Element)obj).getOwnerDocument();
				break;
			}
		}
		return res;
	}

	@Override
	public Document removeProperty(QName name) {
		Document res = null;
		for(Object obj: this.getModelObject().getAny()) {
			QName elmtName = new QName(((Element)obj).getNamespaceURI(), ((Element)obj).getLocalName());
			if(elmtName.equals(name)) {
				if(this.getModelObject().getAny().remove((Element)obj)) {
					res = ((Element)obj).getOwnerDocument();
				}
				break;
			}
		}
		return res;
	}


	@Override
	public <M extends XmlObject> M findProperty(Class<M> clazz) throws XmlObjectReadException {
		M res = null;

		QName qname = getXmlContext().getClassMetadata().get(getClass(),
				ClassMetadataConstants.IMPLEMENTATION_CLASS_CONSTANT_QNAME);
		assert qname != null : 
			"Unexpected null QName, child should correspond to an api element, and thus have a constant QName.";


		Document doc = getProperty(qname);
		InputStream inputStream;
		try {
			inputStream = Util.convertDocumentToInputStream(doc);

			if(inputStream != null) {
				res = getXmlContext().createReader().readFragment((InputStream)inputStream, clazz);
			}
		} catch (XmlObjectValidationException e) {
			throw new XmlObjectReadException(e);
		}   
		return res;
	}


	@Override
	public void clearProperties() {
		this.getModelObject().getAny().clear();
	}

}
