/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends AbstractXmlObjectSchemaBindingImpl {

	@Override
	public String getOriginatingSchemaDir() {
		return "schema/exchange10";
	}

	@Override
	public String getOriginatingSchemaName() {
		return "exchange10.xsd";
	}



	@Override
	public Package getModelObjectPackage() {
		return easybox.easyesb.ebmwebsourcing.com.exchange._1.ObjectFactory.class.getPackage();
	}


	@Override
	public String getOriginatingSchemaNamespaceURI() {
		return Constants.EXCHANGE_NS_URI;
	}


	@SuppressWarnings("unchecked")
	@Override
	public Class<? extends XmlObject>[] getFactorableClasses() {
		List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();


		// type
		factorableClasses.add(HeaderTypeImpl.class);
		factorableClasses.add(BodyTypeImpl.class);
		factorableClasses.add(MessageTypeImpl.class);
		factorableClasses.add(ExchangeTypeImpl.class);

		// element
		factorableClasses.add(HeaderImpl.class);
		factorableClasses.add(BodyImpl.class);
		factorableClasses.add(MessageInImpl.class);
		factorableClasses.add(MessageOutImpl.class);
		factorableClasses.add(MessageErrorImpl.class);
		factorableClasses.add(ExchangeImpl.class);

		return factorableClasses.toArray(new Class[factorableClasses.size()]);
	}


	@Override
	protected XmlObject doWrap(XmlContext xmlContext,
			Constructor<? extends XmlObject> xmlObjectImplConstructor,
			ModelObject ModelObjectObject)
	throws InstantiationException, IllegalAccessException,
	InvocationTargetException {
		return xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
	}

	@Override
	public String getOriginatingSchemaPreferredNamespacePrefix() {
		return "exch";
	}

	@Override
	public String getName() {
		return "exchange10-impl";
	}


}
