/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.impl;



import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.Constants;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.type.MessageType;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbMessageType;


class MessageTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbMessageType> implements
MessageType {

	protected MessageTypeImpl(XmlContext xmlContext, EJaxbMessageType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbMessageType> getCompliantModelClass() {
		return EJaxbMessageType.class;
	}


	@Override
	public Header getHeader() {
		if(getModelObject().getHeader() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getHeader(), Header.class);
		}
		return null;	
	}


	@Override
	public void setHeader(Header value) {
		setChild(value, Header.class);
	}


	@Override
	public boolean hasHeader() {
		return this.getHeader() != null;
	}


	@Override
	public Body getBody() {
		if(getModelObject().getBody() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getBody(), Body.class);
		}
		return null;		}


	@Override
	public void setBody(Body value) {
		setChild(value, Body.class);
	}


	@Override
	public boolean hasBody() {
		return this.getBody() != null;
	}


	@Override
	public Document printMessage() {
		DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
		domFactory.setNamespaceAware(true);

		Document res = null;
		try {
			res = domFactory.newDocumentBuilder().newDocument();

			Element msg = res.createElementNS(Constants.EXCHANGE_NS_URI, "message");
			msg.setPrefix("esb");
			res.appendChild(msg);

			// add header
			Element header = res.createElementNS(Constants.EXCHANGE_NS_URI, "header");
			header.setPrefix("esb");
			msg.appendChild(header);
			if(this.getHeader() != null && this.getHeader().getProperties() != null) {
				for(Document doc: this.getHeader().getProperties()) {
					header.appendChild(res.importNode(doc.getDocumentElement().cloneNode(true), true));
				}
			}

			// add body
			Element body = res.createElementNS(Constants.EXCHANGE_NS_URI, "body");
			body.setPrefix("esb");
			msg.appendChild(body);
			if(this.getBody() != null && this.getBody().getPayload() != null) {
				body.appendChild(res.importNode(this.getBody().getPayload().getDocumentElement().cloneNode(true), true));
			}

		} catch (ParserConfigurationException e) {
			// do nothing
		}


		return res;

	}



}
