/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport.endpoint.RawReportSubscriptionEndpoint;
import com.ebmwebsourcing.easyesb.rawreport.endpoint.RawReportSubscriptionEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.TechnicalServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;

public class RawReportSubscriptionServiceBehaviourImpl extends ServiceBehaviourImpl implements RawReportSubscriptionServiceBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(RawReportSubscriptionServiceBehaviourImpl.class.getName());


	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private RawReportSubscriptionEndpoint<? extends ProviderEndpointType> rawReportSubscriptionEndpoint = null;


	public RawReportSubscriptionServiceBehaviourImpl(TechnicalServiceImpl<? extends TechnicalServiceType> ep) {
		super(ep);
	}

	public void execute(Exchange exchange) throws TransportException {
		this.execute(exchange);

	}

	@SuppressWarnings("unchecked")
	public RawReportSubscriptionEndpoint<? extends ProviderEndpointType> createRawReportSubscriptionEndpoint(
			String name, EndpointInitialContext context) throws ESBException {

		this.rawReportSubscriptionEndpoint = this.createProviderEndpoint(name, RawReportSubscriptionEndpointImpl.class, SubscriptionManagerEndpointBehaviourImpl.class, context);
		try {
			this.rawReportSubscriptionEndpoint.addBehaviourClass(NotificationProducerEndpointBehaviourImpl.class);
			String topicDef = "" +
					"<wstop:TopicSet xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:tns1=\"http://www.petalslink.org/rawreport/1.0\" >\n" + 
					"    <tns1:RawReportTopic wstop:topic=\"true\" />\n" + 
					"</wstop:TopicSet>\n";

			InputStream is = new ByteArrayInputStream(topicDef.getBytes());
			TopicSetType topicSet = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl()).getWstopReader().readTopicSetType(new InputSource(is));
			is.close();

			SubscriptionManagerEndpointBehaviour subscriptionManagerEndpointBehaviour = rawReportSubscriptionEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
			subscriptionManagerEndpointBehaviour.setEvenTopicNamespaceDefinitionUrl(Thread.currentThread().getContextClassLoader().getResource("topicnamespace/resources-events-topicsNS.xml"));
			subscriptionManagerEndpointBehaviour.setTopicSet(topicSet);

			final TopicsManagerEngine wstopTopicsMgr = new TopicsManagerEngine();
			final SubscriptionManagerEngine subscriptionManager = new SubscriptionManagerEngine(
					log);
			EndpointAddress epr = ESBUtil.analyzeURI(this.endpoint.getReference());
			subscriptionManager.setSubscriptionsManagerService(new QName(epr.getNamespace(), epr.getServicename()));    

			final NotificationProducerEngine producer = new NotificationProducerEngine(
					log, wstopTopicsMgr, subscriptionManager, true,
					subscriptionManagerEndpointBehaviour.getTopicSet(), subscriptionManagerEndpointBehaviour.getTopicNs(), "wsn", null /*this.notifSender*/);

			subscriptionManagerEndpointBehaviour.setSubscriptionManager(subscriptionManager);
			NotificationProducerEndpointBehaviour notificationProducerEndpointBehaviour = rawReportSubscriptionEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
			notificationProducerEndpointBehaviour.setNotificationProducer(producer);

			rawReportSubscriptionEndpoint.getNode().findBehaviour(NodeBehaviourImpl.class).getEndpointSubscribers().put(topicSet, (Endpoint<?>) rawReportSubscriptionEndpoint);
		} catch(Exception e) {
			throw new ESBException(e);
		}


		//		if(this.rawReportSubscriptionEndpoint == null) {
		//			try {
		//				
		//				ProviderEndpointType model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint.class);
		//				model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
		//				model.getBehavioursList().addBehaviour(SubscriptionManagerEndpointBehaviourImpl.class.getName());
		//				model.getBehavioursList().addBehaviour(NotificationProducerEndpointBehaviourImpl.class.getName());
		//				model.setType(RawReportSubscriptionEndpointImpl.class.getName());
		//				model.setEndpointInitialContext(context);
		//				model.setName(new QName(this.endpoint.getQName().getNamespaceURI(), name));
		//				model.setNode(this.getNodeQName());
		//				model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());
		//				model.setService(this.endpoint.getQName());
		//
		//				
		//				// add service in registry
		//				if((this.getEndpoint().getNode() != null)&&(((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService() != null)) {
		//					boolean res = ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());
		//				
		//					if(res) {
		//						// get component
		//						rawReportSubscriptionEndpoint = (RawReportSubscriptionEndpoint) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
		//
		//						String topicDef = "" +
		//								"<wstop:TopicSet xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:tns1=\"http://www.petalslink.org/rawreport/1.0\" >\n" + 
		//								"    <tns1:RawReportTopic wstop:topic=\"true\" />\n" + 
		//								"</wstop:TopicSet>\n";
		//						
		//						InputStream is = new ByteArrayInputStream(topicDef.getBytes());
		//						TopicSetType topicSet = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl()).getWstopReader().readTopicSetType(new InputSource(is));
		//						is.close();
		//						
		//						SubscriptionManagerEndpointBehaviour subscriptionManagerEndpointBehaviour = rawReportSubscriptionEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
		//						subscriptionManagerEndpointBehaviour.setEvenTopicNamespaceDefinitionUrl(Thread.currentThread().getContextClassLoader().getResource("topicnamespace/resources-events-topicsNS.xml"));
		//						subscriptionManagerEndpointBehaviour.setTopicSet(topicSet);
		//
		//						final TopicsManagerEngine wstopTopicsMgr = new TopicsManagerEngine();
		//						final SubscriptionManagerEngine subscriptionManager = new SubscriptionManagerEngine(
		//								log);
		//						subscriptionManager.setSubscriptionsManagerService(this.getEndpointQName());    
		//						
		//						final NotificationProducerEngine producer = new NotificationProducerEngine(
		//								log, wstopTopicsMgr, subscriptionManager, true,
		//								subscriptionManagerEndpointBehaviour.getTopicSet(), subscriptionManagerEndpointBehaviour.getTopicNs(), "wsn", null /*this.notifSender*/);
		//						
		//						subscriptionManagerEndpointBehaviour.setSubscriptionManager(subscriptionManager);
		//						NotificationProducerEndpointBehaviour notificationProducerEndpointBehaviour = rawReportSubscriptionEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
		//						notificationProducerEndpointBehaviour.setNotificationProducer(producer);
		//						
		//						rawReportSubscriptionEndpoint.getNode().findBehaviour(NodeBehaviourImpl.class).getEndpointSubscribers().put(topicSet, (Endpoint<?>) rawReportSubscriptionEndpoint);
		//					}
		//				} else {
		//					throw new ESBException("Registry cannot be null"); 
		//				}
		//				
		//			} catch (RegistryFault_Exception e) {
		//				throw new ESBException(e);
		//			} catch (WsnbException e) {
		//				throw new ESBException(e);
		//			} catch (WstopException e) {
		//				throw new ESBException(e);
		//			} catch (IOException e) {
		//				throw new ESBException(e);
		//			} 
		//			log.fine("adminEndpoint " + name + " created and started");
		//		}
		return this.rawReportSubscriptionEndpoint;
	}

	public RawReportSubscriptionEndpoint<? extends ProviderEndpointType> getRawReportSubscriptionEndpoint() {
		return this.rawReportSubscriptionEndpoint;
	}






}
