/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.report.AbstractReportInterceptor;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.report.ClientReportInterceptor;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class ProviderReportInterceptor
extends AbstractReportInterceptor
implements ProviderEndpointInvocationInterceptor {
    private static Logger log = Logger.getLogger(ClientReportInterceptor.class.getName());
    private Configuration conf;

    public ProviderReportInterceptor(Configuration conf, Endpoint endpoint) throws ESBException {
        super(endpoint);
        this.conf = conf;
    }

    public void processingExchangeBeforeSending(Exchange ex) throws TransportException {
    }

    public void processingExchangeAfterReceiving(Exchange exchange) throws TransportException {
        log.finest("t2: report interception");
        Document sourNodeInfo = exchange.getMessageIn().getHeader().getProperty(SourceNodeInformations.QNAME);
        if (sourNodeInfo != null) {
            SourceNodeInformations sourNodeInfoModel = null;
            try {
                sourNodeInfoModel = (SourceNodeInformations)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(sourNodeInfo, SourceNodeInformations.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warning("Failed to retrieve sourceNodeInformation to get services Information");
            }
        }
        log.finest("t2: report sent for exchange " + exchange.getUuid());
        if (exchange != null) {
            log.finest("t2: report exchange not null");
            ReportList reports = this.createReportListFromExchangeT1T2(exchange);
            log.finest("t2: reports created");
            if (reports.getReports().length > 0) {
                log.finest("t2: reports sent ...");
                try {
                    this.sendReport(reports);
                }
                catch (ESBException e) {
                    e.printStackTrace();
                }
            }
        } else {
            log.severe("ERROR: TIMEOUT => Impossible to create report");
        }
    }
}

