/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.api.util;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MessageUtil {
    public static final QName EXCHANGE_ACCEPTED_BY_PROVIDER_PROPERTY = new QName("http://com.petalslink.easyesb/exchange/1.0", "exchange-accepted-by-provider");
    private static MessageUtil INSTANCE = null;

    private MessageUtil() {
    }

    public static MessageUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MessageUtil();
        }
        return INSTANCE;
    }

    public String getSOAPTransporterAddress(String host, String port) {
        return "http://" + host + ":" + port + "/" + "transporter";
    }

    public void createInMessageStructure(Exchange exchange) {
        if (exchange.getMessageIn() == null) {
            MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
            exchange.setMessageIn(msgIn);
        }
        if (exchange.getMessageIn().getBody() == null) {
            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            exchange.getMessageIn().setBody(body);
        }
    }

    public void createOutMessageStructure(Exchange exchange) {
        if (exchange.getMessageOut() == null) {
            MessageOut msgOut = (MessageOut)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
            exchange.setMessageOut(msgOut);
        }
        if (exchange.getMessageOut().getBody() == null) {
            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            exchange.getMessageOut().setBody(body);
        }
    }

    public void createErrorMessageStructure(Exchange exchange) {
        if (exchange.getMessageError() == null) {
            MessageError msgError = (MessageError)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
            exchange.setMessageError(msgError);
        }
        if (exchange.getMessageError().getBody() == null) {
            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            exchange.getMessageError().setBody(body);
        }
    }

    public Document createHeaderProperty(QName qName, String value) throws ESBException {
        Document res = null;
        try {
            res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Element timestamp = res.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
            timestamp.setNodeValue(value.toString());
            res.appendChild(timestamp);
        }
        catch (ParserConfigurationException e) {
            throw new ESBException(e);
        }
        return res;
    }

    public Exchange createMessageExchange(ClientEndpoint sourceEndpoint, QName providerEndpoint, QName interfaceName, QName operation, PatternType mep, String msg) throws TransportException {
        Exchange me = null;
        try {
            me = sourceEndpoint.createExchange();
            me.setPattern(mep);
            me.setDestination(providerEndpoint);
            me.setInterfaceName(interfaceName);
            me.setOperation(operation.toString());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(msg.getBytes()));
            this.createInMessageStructure(me);
            me.getMessageIn().getBody().setPayload(doc);
            Header header = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
            SourceNodeInformations sourceNodeInfos = (SourceNodeInformations)sourceEndpoint.getNode().getModel().getBasicNodeInformations().duplicateXmlObjectAs(SourceNodeInformations.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)sourceNodeInfos, (OutputStream)baos);
            ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
            Document sourceNodeInfosAsDom = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
            header.addProperty(sourceNodeInfosAsDom);
            me.getMessageIn().setHeader(header);
            writtenStream.close();
        }
        catch (SAXException e) {
            throw new TransportException((Throwable)e);
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TransportException((Throwable)e);
        }
        catch (ExchangeException e) {
            throw new TransportException((Throwable)e);
        }
        catch (XmlObjectWriteException e) {
            throw new TransportException((Throwable)e);
        }
        return me;
    }
}

