/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package com.ebmwebsourcing.easyesb.soa.api.config;

import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public interface Configuration {


	public static final String PORT = "port";
	public static final String DEFAULT_PORT = "9000";

	public static final String HOST = "host";
	public static final String DEFAULT_HOST = "localhost";

	public static final String COMMON_ENDPOINT_INITIALIZATION_INTERCEPTOR = "common-endpoint-initialization-interceptor";

	public static final String REGISTRY_SERVICE_CLASS = "registry-service-class";
	public static final String REGISTRY_SERVICE_BEHAVIOUR_CLASS = "registry-service-behaviour-class";

	
	/**
	 * @return the data
	 */
	Map<String, String> getProperties();

	void addProperty(String key, String value);

	Integer getPort();

	void setPort(int port);

	String getHost();

	void setHost(String host);



	List<String> getEndpointInitializationInterceptorClassNames();

	void addEndpointInitializationInterceptorClassName(String eii);

	Class<? extends RegistryService> getRegistryServiceClass();

	void setRegistryServiceClass(Class<? extends RegistryService> clazz);

	Class<? extends RegistryServiceBehaviour> getRegistryServiceBehaviourClass();

	void setRegistryServiceBehaviourClass(Class<? extends RegistryServiceBehaviour> clazz);


}
