/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

import org.petalslink.abslayer.service.api.Binding;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public abstract class AbstractEndpointBehaviourImpl implements EndpointBehaviour {
	
	private static Logger log = Logger.getLogger(AbstractEndpointBehaviourImpl.class.getName());

	private Binding binding;
	
	public Endpoint<? extends EndpointType> endpoint;
	
	
	/**
	 * the default constructor is mandatory
	 */
	public AbstractEndpointBehaviourImpl(Endpoint<? extends EndpointType> ep) {
		this.endpoint = ep;
	}

	public Endpoint<? extends EndpointType> getEndpoint() {
		return this.endpoint;
	}
	
	public void execute(Exchange exchange) throws TransportException {
		log.finest("operation invoked: " + exchange.getOperation());
		Method m = findMethod(exchange.getOperation());
		if(m != null) {
			try {
				m.invoke(this, new Object[0]);
			} catch (IllegalArgumentException e) {
				throw new TransportException(e);
			} catch (IllegalAccessException e) {
				throw new TransportException(e);
			} catch (InvocationTargetException e) {
				throw new TransportException(e);
			}
		}
	}

	protected Method findMethod(String operation) {
		Method res = null;
		for(Method m: EndpointBehaviour.class.getMethods()) {
			if(m.getName().equals(operation)) {
				res = m;
				break;
			}
		}
		return res;
	}

	// soap method
	public String getBehaviourClassName() {
		return this.getClass().getName();
	}

	
	public Binding getBinding() {
		return binding;
	}

	public void setBinding(Binding binding) {
		this.binding = binding;
	}
}
