/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.transport;

import java.util.List;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;


public interface Skeleton {
	
	boolean getTakeToSendResponseInCharge() ;

	void setTakeToSendResponseInCharge(boolean takeToSendResponseInCharge);
	
	TransportersManager getTransportersManager() throws ESBException;

	void accept(Exchange message) throws TransportException;
	
	void sendResponseToClient(Exchange exchange)
	throws TransportException;
	
	void addProviderEndpointInvocationInterceptor(ProviderEndpointInvocationInterceptor i);
	
	ProviderEndpointInvocationInterceptor removeProviderEndpointInvocationInterceptor(ProviderEndpointInvocationInterceptor i);
	
	ProviderEndpointInvocationInterceptor[] getProviderEndpointInvocationInterceptors();

	
}
