/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;

public abstract class NotificationConsumerEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements NotificationConsumerEndpointBehaviour {


	private static Logger log = Logger.getLogger(NotificationConsumerEndpointBehaviourImpl.class.getName());


	private static Binding b; 
	static {
		try {
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL), Definitions.class));
			b = desc.getBindings().iterator().next();
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		}
	}


	public NotificationConsumerEndpointBehaviourImpl(
			ProviderEndpoint<? extends ProviderEndpointType> ep) {
		super(ep);

		this.setBinding(b);

	}


	public void execute(final Exchange exchange) throws TransportException  {
		try {
			log.finest("notification consumer BEHAVIOUR FOUND: " + exchange.getOperation());
			log.finest("notification consumer BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()));

			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("Notify")
					&& (exchange.getMessageIn().getBody().getPayload() instanceof Document)) {
				log.finest("NOTIFY");
				Notify notify;

				notify = RefinedWsnbFactory.getInstance().getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());

				this.notify(notify);
			} 
		} catch (WsnbException e) {
			log.severe("ERROR IN NOTIFICATION CONSUMER ENDPOINT BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		}
	}


}
