/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalSender;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderProxyEndpointType;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;

@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ProviderProxyEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ProviderProxyEndpointImpl<M extends ProviderProxyEndpointType> extends ProviderEndpointImpl<M> implements ProviderProxyEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Map<String, ExternalSender> senders = new HashMap<String, ExternalSender>();

	private boolean isAdaptedDescription = false;


	public ProviderProxyEndpointImpl() {
		super();
	}

	public ProviderProxyEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}


	public String getExternalAddress() {
		return this.model.getExternalAddress();
	}


	public void setExternalAddress(String address) {
		this.model.setExternalAddress(address);
	}


	public Map<String, ExternalSender> getExternalSenders() {
		return this.senders;
	}


	public void setExternalSenders(Map<String, ExternalSender> senders) {
		this.senders = senders;
	}

	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ProviderProxyEndpointType.class;
		}
		return res;
	}

	@Override
	public Description getDescription() {
		if(!isAdaptedDescription) {
			Description desc = null;
			try {
				desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(this.getWSDLDescriptionAddress().toURL(), Definitions.class));

			} catch (MalformedURLException e) {
				desc = null;
			} catch (IOException e) {
				desc = null;
			} catch (XmlObjectReadException e) {
				desc = null;
			}
			if(desc != null) {
				super.setDescription(desc);
			}
		}
		return super.getDescription();
	}

	@Override
	public void setDescription(Description desc) {
		super.setDescription(desc);
		isAdaptedDescription = true;
	}

}
