/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.transport.listener;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.Listener;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import easyesb.petalslink.com.transporter._1.ObjectFactory;
import easyesb.petalslink.com.transporter._1.TransportExceptionElement;
import easyesb.petalslink.com.transporter._1_0.TransportExceptionFault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class ListenerImpl
implements Listener {
    private static Logger log = Logger.getLogger(ListenerImpl.class.getName());
    private static final int REFRESH_FREQUENCY = 100;
    private Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap());

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public ListenerImpl(Map<QName, Endpoint<? extends EndpointType>> endpoints) {
        this.endpoints = endpoints;
    }

    public void run() {
        Exchange exchange = null;
        try {
            for (Endpoint<? extends EndpointType> ep : new ArrayList<Endpoint<? extends EndpointType>>(this.endpoints.values())) {
                try {
                    if (ep != null && ep.getNode() != null && ep.getTransportersManager() != null) {
                        exchange = ep.getNode().getTransportersManager().pull(ep.getQName(), ep.getNode().getQName());
                    }
                    if (exchange == null) continue;
                    ep.accept(exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (exchange != null) {
                        try {
                            TransportExceptionFault exception = new TransportExceptionFault("Technical Error", new TransportExceptionElement());
                            exception.getFaultInfo().setErrorMsg(e.getMessage());
                            exception.getFaultInfo().setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
                            Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)exception.getFaultInfo());
                            Document fault = SOAPHandler.createSoapFault((Document)docEx);
                            if (exchange.getMessageError() == null) {
                                MessageError msgError = (MessageError)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
                                exchange.setMessageError(msgError);
                            }
                            if (exchange.getMessageError().getBody() == null) {
                                Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                                exchange.getMessageError().setBody(body);
                            }
                            exchange.getMessageError().getBody().setPayload(fault);
                            log.finest("TECHNICAL ERROR: \n" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageError().getBody().getPayload()));
                            ep.sendResponseToClient(exchange);
                        }
                        catch (SOAException ex) {
                            ex.printStackTrace();
                            log.severe(ex.getMessage());
                        }
                        catch (SOAPException ex) {
                            ex.printStackTrace();
                            log.severe(ex.getMessage());
                        }
                        continue;
                    }
                    e.printStackTrace();
                    log.severe(e.getMessage());
                }
            }
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe(e.getMessage());
        }
    }
}

