/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ClientProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalListener;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ListenerInitialisationType;

@Scope("COMPOSITE")
@Service(value=ClientProxyEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ClientProxyEndpointImpl<M extends ClientProxyEndpointType> extends ClientEndpointImpl<M> implements ClientProxyEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AbstractEndpointImpl.class.getName());

	private List<ExternalListener> listeners = new ArrayList<ExternalListener>();

	// only used by frascati
	public ClientProxyEndpointImpl() throws ESBException {
		super();
	}

	public ClientProxyEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}

	@Override
	public void init() throws ESBException {
		super.init();
		try {
			for(ListenerInitialisationType listenerInit: this.getModel().getListenerInitialisations()) {
				ExternalServer server = findServer(listenerInit.getServerName());
				if(server == null) {
					throw new ESBException("Impossible to find server: " + listenerInit.getServerName());
				}
				ExternalListener listener = createExternalListenerFormClass((Class<? extends ExternalListener>) Class.forName(listenerInit.getClassName()), server);
				this.listeners.add(listener);
			}
		} catch (ClassNotFoundException e) {
			throw new ESBException(e);
		}
	}

	private ExternalServer findServer(String serverName) {
		ExternalServer server = ((NodeBehaviour)this.getNode().findBehaviour(NodeBehaviour.class)).getExternalServer(serverName);
		return server;
	}

	protected ExternalListener createExternalListenerFormClass(
			Class<? extends ExternalListener> behaviourClass, ExternalServer server)
					throws ESBException {
		ExternalListener res = null;
		if(behaviourClass != null) {
			if(behaviourClass.isInterface()) {
				throw new ESBException("Impossible to add an interface, give the implementation");
			}
			log.fine("create externalListener: " + behaviourClass);
			System.out.println("create externalListener: " + behaviourClass);
			try {
				Constructor<ExternalListener> constructor = (Constructor<ExternalListener>) behaviourClass.getConstructors()[0];
				res = constructor.newInstance(this, server);
			} catch (IllegalArgumentException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (InstantiationException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (IllegalAccessException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (InvocationTargetException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (SecurityException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} 
		}
		return res;
	}

	public String getProviderEndpointName() {
		return this.model.getProviderEndpointName();
	}

	public void setProviderEndpointName(String providerQName) {
		this.model.setProviderEndpointName(providerQName);
	}


	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ClientProxyEndpointType.class;
		}
		return res;
	}

	public QName getProviderServiceName() {
		return this.model.getProviderServiceName();
	}

	public void setProviderServiceName(QName providerQName) {
		this.model.setProviderServiceName(providerQName);
	}

	@Override
	public Description getDescription() {
		if(description == null) {
			ClientProxyBehaviour cpb = this.findBehaviour(ClientProxyBehaviour.class);
			if(cpb != null) {
				description = cpb.getDescription2Provider();
			}
		}
		return description;
	}

	@Override
	public ExternalListener[] getExternalListeners() {
		return this.listeners.toArray(new ExternalListener[this.listeners.size()]);
	}

}
