/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalSender;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.SenderInitialisationType;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

@Scope(value="COMPOSITE")
@Service(value={ProviderProxyEndpoint.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class ProviderProxyEndpointImpl<M extends ProviderProxyEndpointType>
extends ProviderEndpointImpl<M>
implements ProviderProxyEndpoint<M> {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ProviderProxyEndpointImpl.class.getName());
    private boolean isAdaptedDescription = false;
    private List<ExternalSender> senders = new ArrayList<ExternalSender>();

    public ProviderProxyEndpointImpl() throws ESBException {
    }

    public ProviderProxyEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
        super(model, parent);
    }

    @Override
    public void init() throws ESBException {
        super.init();
        try {
            SenderInitialisationType[] senderInitialisationTypeArray = ((ProviderProxyEndpointType)this.getModel()).getSenderInitialisations();
            int n = senderInitialisationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SenderInitialisationType senderInit = senderInitialisationTypeArray[n2];
                ExternalSender sender = this.createExternalSenderFormClass(Class.forName(senderInit.getClassName()));
                sender.setExternalAddress(senderInit.getExternalProviderAddress());
                this.senders.add(sender);
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ESBException((Throwable)e);
        }
    }

    private ExternalSender createExternalSenderFormClass(Class<? extends ExternalSender> behaviourClass) throws ESBException {
        ExternalSender res = null;
        if (behaviourClass != null) {
            if (behaviourClass.isInterface()) {
                throw new ESBException("Impossible to add an interface, give the implementation");
            }
            log.fine("create externalSender: " + behaviourClass);
            System.out.println("create externalSender: " + behaviourClass);
            try {
                Constructor<?> constructor = behaviourClass.getConstructors()[0];
                res = (ExternalSender)constructor.newInstance(new Object[]{this});
            }
            catch (IllegalArgumentException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (InstantiationException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (SecurityException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
        }
        return res;
    }

    @Override
    public Class<M> getModelClass() {
        Class res = null;
        res = this.model != null ? ((ProviderProxyEndpointType)this.model).getClass() : ProviderProxyEndpointType.class;
        return res;
    }

    @Override
    public Description getDescription() {
        if (!this.isAdaptedDescription) {
            Description desc = null;
            try {
                desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(this.getWSDLDescriptionAddress().toURL(), Definitions.class));
            }
            catch (MalformedURLException e) {
                desc = null;
            }
            catch (IOException e) {
                desc = null;
            }
            catch (XmlObjectReadException e) {
                desc = null;
            }
            if (desc != null) {
                super.setDescription(desc);
            }
        }
        return super.getDescription();
    }

    @Override
    public void setDescription(Description desc) {
        super.setDescription(desc);
        this.isAdaptedDescription = true;
    }

    public ExternalSender[] getExternalSenders() {
        return this.senders.toArray(new ExternalSender[this.senders.size()]);
    }
}

