/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderProxyEndpointType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderProxyEndpointType;


class ProviderProxyEndpointTypeImpl extends EndpointTypeImpl<EJaxbProviderProxyEndpointType> implements
ProviderProxyEndpointType {

	protected ProviderProxyEndpointTypeImpl(XmlContext xmlContext, EJaxbProviderProxyEndpointType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbProviderProxyEndpointType> getCompliantModelClass() {
		return EJaxbProviderProxyEndpointType.class;
	}


	@Override
	public QName getService() {
		return this.getModelObject().getServiceName();
	}


	@Override
	public void setService(QName value) {
		this.getModelObject().setServiceName(value);
	}


	@Override
	public boolean hasService() {
		return this.getService() != null;
	}


	@Override
	public String getWsdlDescription() {
		return this.getModelObject().getWsdlDescription();
	}


	@Override
	public void setWsdlDescription(String value) {
		this.getModelObject().setWsdlDescription(value);
	}


	@Override
	public boolean hasWsdlDescription() {
		return this.getWsdlDescription() != null;
	}


	@Override
	public String getExternalAddress() {
		return this.getModelObject().getExternalAddress();
	}


	@Override
	public void setExternalAddress(String value) {
		this.getModelObject().setExternalAddress(value);
	}


	@Override
	public boolean hasExternalAddress() {
		return this.getExternalAddress() != null;
	}
}
