/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.QNameListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbQNameListType;


class QNameListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbQNameListType> implements
QNameListType {

	protected QNameListTypeImpl(XmlContext xmlContext, EJaxbQNameListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbQNameListType> getCompliantModelClass() {
		return EJaxbQNameListType.class;
	}


	@Override
	public QName[] getNames() {
		return (QName[]) this.getModelObject().getName().toArray();
	}


	@Override
	public void addName(QName nn) {
		this.getModelObject().getName().add(nn);
	}


	@Override
	public void removeName(QName nn) {
		this.getModelObject().getName().remove(nn);
	}


	@Override
	public void clearNames() {
		this.getModelObject().getName().clear();
	}


}
