/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderEndpointType;


public class ProviderEndpointTypeImpl extends ClientEndpointTypeImpl<EJaxbProviderEndpointType> implements
ProviderEndpointType {

	protected ProviderEndpointTypeImpl(XmlContext xmlContext, EJaxbProviderEndpointType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbProviderEndpointType> getCompliantModelClass() {
		return EJaxbProviderEndpointType.class;
	}


	@Override
	public QName getServiceName() {
		return this.getModelObject().getServiceName();
	}


	@Override
	public void setServiceName(QName value) {
		this.getModelObject().setServiceName(value);
	}


	@Override
	public boolean hasServiceName() {
		return this.getServiceName() != null;
	}


	@Override
	public String getWsdlDescription() {
		return this.getModelObject().getWsdlDescription();
	}


	@Override
	public void setWsdlDescription(String value) {
		this.getModelObject().setWsdlDescription(value);
	}


	@Override
	public boolean hasWsdlDescription() {
		return this.getWsdlDescription() != null;
	}


	@Override
	public String getName() {
		return this.getModelObject().getName();
	}


	@Override
	public void setName(String endpoint) {
		this.getModelObject().setName(endpoint);
	}


	@Override
	public boolean hasName() {
		return this.getName() != null;
	}

}
