/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easyesb.soa10.api.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/soa10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "soa10.xsd";
    }
    


    @Override
    public Package getModelObjectPackage() {
        return easybox.easyesb.petalslink.com.soa.model.datatype._1.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.SOA_DATAMODEL_NS_URI;
    }
    
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        
        // type
        factorableClasses.add(BasicNodeInformationsTypeImpl.class);
        factorableClasses.add(BusinessServiceTypeImpl.class);
        factorableClasses.add(ClientEndpointTypeImpl.class);
        factorableClasses.add(ClientProxyEndpointTypeImpl.class);
        factorableClasses.add(ComponentTypeImpl.class);
        factorableClasses.add(EndpointInitializationContextTypeImpl.class);
        factorableClasses.add(EndpointTypeImpl.class);
        factorableClasses.add(InitializationInterceptorListTypeImpl.class);
        factorableClasses.add(NodeTypeImpl.class);
        factorableClasses.add(ProviderEndpointTypeImpl.class);
        factorableClasses.add(ProviderProxyEndpointTypeImpl.class);
        factorableClasses.add(RegistryEndpointTypeImpl.class);
        factorableClasses.add(RegistryServiceTypeImpl.class);
        factorableClasses.add(ServiceTypeImpl.class);
        factorableClasses.add(TechnicalServiceTypeImpl.class);
        factorableClasses.add(TransporterListTypeImpl.class);
        factorableClasses.add(URIListTypeImpl.class);
        factorableClasses.add(EndpointsGroupListTypeImpl.class);
        factorableClasses.add(ServicesGroupListTypeImpl.class);
        factorableClasses.add(ProviderEndpointsGroupListTypeImpl.class);
        factorableClasses.add(ClientEndpointsGroupListTypeImpl.class);
        factorableClasses.add(GenericEndpointTypeImpl.class);
        factorableClasses.add(BehavioursListTypeImpl.class);
        factorableClasses.add(SenderInitialisationTypeImpl.class);
        factorableClasses.add(ListenerInitialisationTypeImpl.class);
        
        // element
        factorableClasses.add(SourceNodeInformationsImpl.class);
        factorableClasses.add(BasicNodeInformationsImpl.class);
        factorableClasses.add(ClientEndpointImpl.class);
        factorableClasses.add(ComponentImpl.class);
        factorableClasses.add(EndpointInitialContextImpl.class);
        factorableClasses.add(InitializationInterceptorListImpl.class);
        factorableClasses.add(LocalEndpointsGroupListImpl.class);
        factorableClasses.add(NeighbourNodeImpl.class);
        factorableClasses.add(NodeImpl.class);
        factorableClasses.add(ProviderEndpointImpl.class);
        factorableClasses.add(RegistryImpl.class);
        factorableClasses.add(RemoteEndpointsGroupListImpl.class);
        factorableClasses.add(ServicesGroupListImpl.class);
        factorableClasses.add(TransporterListImpl.class);
        factorableClasses.add(ProviderEndpointsGroupListImpl.class);
        factorableClasses.add(ClientProxyEndpointImpl.class);
        factorableClasses.add(ProviderProxyEndpointImpl.class);
        factorableClasses.add(ClientEndpointsGroupListImpl.class);
        factorableClasses.add(TechnicalServiceImpl.class);
        factorableClasses.add(BusinessServiceImpl.class);
        factorableClasses.add(GenericEndpointImpl.class);
        factorableClasses.add(BehavioursListImpl.class);
        factorableClasses.add(SenderInitalisationImpl.class);
        factorableClasses.add(ListenerInitalisationImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObjectObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
    }
    

	@Override
	public String getOriginatingSchemaPreferredNamespacePrefix() {
		return "soa";
	}

	@Override
	public String getName() {
		return "soa10-impl";
	}


}
