/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;




import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointsGroupListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointsGroupListType;


class EndpointsGroupListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbEndpointsGroupListType> implements
EndpointsGroupListType {

	protected EndpointsGroupListTypeImpl(XmlContext xmlContext, EJaxbEndpointsGroupListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbEndpointsGroupListType> getCompliantModelClass() {
		return EJaxbEndpointsGroupListType.class;
	}


	@Override
	public EndpointType[] getEndpoints() {
		return createChildrenArray(getModelObject()
				.getEndpointGroup(), EJaxbEndpointType.class,
				ANY_QNAME, EndpointType.class);
	}


	@Override
	public void addEndpoint(EndpointType pe) {
		addToChildren(getModelObject().getEndpointGroup(), pe);
	}


	@Override
	public void removeEndpoint(EndpointType pe) {
		removeFromChildren(getModelObject().getEndpointGroup(), pe);
	}


	@Override
	public void clearEndpoints() {
		clearChildren(getModelObject().getEndpointGroup(),
				EJaxbEndpointType.class, ANY_QNAME);
	}


	@Override
	public EndpointType getEndpointByReference(String ref) {
		EndpointType res = null;
		for(EndpointType pe: this.getEndpoints()) {
			if(pe.getReference().equals(ref)) {
				res = pe;
				break;
			}
		}
		return res;
	}





}
