/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;




import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServicesGroupListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbServiceType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbServicesGroupListType;


class ServicesGroupListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbServicesGroupListType> implements
ServicesGroupListType {

	protected ServicesGroupListTypeImpl(XmlContext xmlContext, EJaxbServicesGroupListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbServicesGroupListType> getCompliantModelClass() {
		return EJaxbServicesGroupListType.class;
	}


	@Override
	public ServiceType[] getServices() {
		return createChildrenArray(getModelObject()
                .getServiceGroup(), EJaxbServiceType.class,
                ANY_QNAME, ServiceType.class);
	}


	@Override
	public void addService(ServiceType pe) {
		addToChildren(getModelObject().getServiceGroup(), pe);
	}


	@Override
	public void removeService(ServiceType pe) {
		removeFromChildren(getModelObject().getServiceGroup(), pe);
	}


	@Override
	public void clearServices() {
		clearChildren(getModelObject().getServiceGroup(),
				EJaxbServiceType.class, ANY_QNAME);
	}


	@Override
	public ServiceType getServiceByReference(String ref) {
		ServiceType res = null;
		for(ServiceType pe: this.getServices()) {
			if(pe.getReference().equals(ref)) {
				res = pe;
				break;
			}
		}
		return res;
	}



}
