/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BusinessService;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.Component;
import com.ebmwebsourcing.easyesb.soa10.api.element.Node;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.TechnicalService;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.GenericEndpointType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbGenericEndpointType;


class GenericEndpointTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbGenericEndpointType> implements
GenericEndpointType {

	protected GenericEndpointTypeImpl(XmlContext xmlContext, EJaxbGenericEndpointType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbGenericEndpointType> getCompliantModelClass() {
		return EJaxbGenericEndpointType.class;
	}


	@Override
	public EndpointType getEndpoint() {
		EndpointType res = null;
		if(this.getModelObject().isSetBusinessService()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getBusinessService(), BusinessService.class);
		} else if(this.getModelObject().isSetClientEndpoint()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getClientEndpoint(), ClientEndpoint.class);
		} else if(this.getModelObject().isSetClientProxyEndpoint()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getClientProxyEndpoint(), ClientProxyEndpoint.class);
		} else if(this.getModelObject().isSetComponent()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getComponent(), Component.class);
		} else if(this.getModelObject().isSetNode()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getNode(), Node.class);
		} else if(this.getModelObject().isSetProviderEndpoint()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getProviderEndpoint(), ProviderEndpoint.class);
		} else if(this.getModelObject().isSetProviderProxyEndpoint()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getProviderProxyEndpoint(), ProviderProxyEndpoint.class);
		} else if(this.getModelObject().isSetTechnicalService()) {
			res = this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getTechnicalService(), TechnicalService.class);
		}  
		return res;
	}


	@Override
	public void setEndpoint(EndpointType value) {
		if(value instanceof BusinessService) {
			setChild(value, BusinessService.class);
		} else if(value instanceof ClientEndpoint) {
			setChild(value, ClientEndpoint.class);
		} else if(value instanceof ClientProxyEndpoint) {
			setChild(value, ClientProxyEndpoint.class);
		} else if(value instanceof Component) {
			setChild(value, Component.class);
		} else if(value instanceof Node) {
			setChild(value, Node.class);
		} else if(value instanceof ProviderEndpoint) {
			setChild(value, ProviderEndpoint.class);
		} else if(value instanceof ProviderProxyEndpoint) {
			setChild(value, ProviderProxyEndpoint.class);
		} else if(value instanceof TechnicalService) {
			setChild(value, TechnicalService.class);
		}
	}


	@Override
	public boolean hasClientEndpoint() {
		return this.getEndpoint() != null;
	}



}
