/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbComponentType;

class ComponentTypeImpl extends EndpointTypeImpl<EJaxbComponentType> implements
ComponentType {

	protected ComponentTypeImpl(XmlContext xmlContext, EJaxbComponentType jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	protected Class<EJaxbComponentType> getCompliantModelClass() {
		return EJaxbComponentType.class;
	}

	@Override
	public ServicesGroupList getServicesGroupList() {
		if(getModelObject().getServicesGroupList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getServicesGroupList(), ServicesGroupList.class);
		}
		return null;
	}

	@Override
	public void setServicesGroupList(ServicesGroupList value) {
		setChild(value, ServicesGroupList.class);
	}

	@Override
	public boolean hasServicesGroupList() {
		return this.getServicesGroupList() != null;
	}

	@Override
	public QName getServiceName() {
		return this.getModelObject().getServiceName();
	}

	@Override
	public void setServiceName(QName value) {
		this.getModelObject().setServiceName(value);
	}

	@Override
	public boolean hasServiceName() {
		return this.getServiceName() != null;
	}

	@Override
	public String getWsdlDescription() {
		return this.getModelObject().getWsdlDescription();
	}

	@Override
	public void setWsdlDescription(String value) {
		this.getModelObject().setWsdlDescription(value);
	}

	@Override
	public boolean hasWsdlDescription() {
		return this.getWsdlDescription() != null;
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public boolean hasName() {
		return this.getName() != null;
	}

	@Override
	public void setName(String endpoint) {
		this.getModelObject().setName(endpoint);
	}



}
