/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.technical.service.registry;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.BusinessService;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.TechnicalService;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BasicNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.NeighbourNode;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.TransporterList;
import com.ebmwebsourcing.easyesb.soa10.api.type.BasicNodeInformationsType;
import com.ebmwebsourcing.easyesb.soa10.api.type.BusinessServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TransporterType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransporterImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBusinessServiceType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientProxyEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbComponentType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderProxyEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbQNameListType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbTechnicalServiceType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbTransporterType;
import easyesb.ebmwebsourcing.com.soa.model.registry.AddEndpoint;
import easyesb.ebmwebsourcing.com.soa.model.registry.AddEndpointResponse;
import easyesb.ebmwebsourcing.com.soa.model.registry.AddNeighBourNode;
import easyesb.ebmwebsourcing.com.soa.model.registry.AddNeighBourNodeResponse;
import easyesb.ebmwebsourcing.com.soa.model.registry.GetRemoteEndpoint;
import easyesb.ebmwebsourcing.com.soa.model.registry.GetRemoteEndpointResponse;
import easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;

public class RegistryEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements RegistryEndpointBehaviour {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(RegistryEndpointBehaviourImpl.class.getName());
    private Map<QName, BasicNodeInformationsType> neighbourNodes = new HashMap<QName, BasicNodeInformationsType>();
    private Map<QName, Endpoint<? extends EndpointType>> localEndpoints = new HashMap<QName, Endpoint<? extends EndpointType>>();
    private Map<QName, EndpointType> remoteEndpoints = new HashMap<QName, EndpointType>();
    private ObjectFactory factory = new ObjectFactory();
    private static Binding b;

    static {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/registryEndpointBehaviour.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(url, Definitions.class));
            b = (Binding)desc.getBindings().iterator().next();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public RegistryEndpointBehaviourImpl(RegistryEndpoint<? extends RegistryEndpointType> reg) {
        super(reg);
        this.setBinding(b);
    }

    public List<BusinessService<? extends ServiceType>> getBusinessServices() {
        ArrayList<BusinessService<? extends ServiceType>> services = new ArrayList<BusinessService<? extends ServiceType>>();
        for (Endpoint<? extends EndpointType> ep : this.localEndpoints.values()) {
            if (!(ep instanceof BusinessService)) continue;
            services.add((BusinessService<? extends ServiceType>)((BusinessService)ep));
        }
        return services;
    }

    public List<TechnicalService<? extends ServiceType>> getTechnicalServices() {
        ArrayList<TechnicalService<? extends ServiceType>> services = new ArrayList<TechnicalService<? extends ServiceType>>();
        for (Endpoint<? extends EndpointType> ep : this.localEndpoints.values()) {
            if (!(ep instanceof TechnicalService)) continue;
            services.add((TechnicalService<? extends ServiceType>)((TechnicalService)ep));
        }
        return services;
    }

    public EndpointType getEndpoint(QName endpointName) throws ESBException {
        EndpointType res = null;
        log.finest("actual node: " + this.getEndpoint().getNode().getQName());
        log.finest("find endpoint: " + endpointName);
        try {
            EJaxbEndpointType remoteEndpoint = this.getRemoteEndpoint(endpointName, null);
            if (remoteEndpoint != null) {
                res = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)remoteEndpoint, EndpointType.class);
            }
        }
        catch (RegistryFault_Exception e) {
            throw new ESBException((Throwable)e);
        }
        return res;
    }

    public Endpoint<? extends EndpointType> getLocalEndpoint(QName endpointName) {
        Endpoint<? extends EndpointType> res = null;
        res = this.localEndpoints.get(endpointName);
        return res;
    }

    public List<Endpoint<? extends EndpointType>> getLocalEndpoints() {
        return new ArrayList<Endpoint<? extends EndpointType>>(this.localEndpoints.values());
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            super.execute(exchange);
            log.finest("operation invoked: " + exchange.getOperation());
            DOMBuilder builder = new DOMBuilder();
            Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getRemoteEndpoint") && exchange.getMessageIn().getBody().getPayload() instanceof org.w3c.dom.Document) {
                log.finest("GET REMOTE ENDPOINT METHOD");
                GetRemoteEndpoint getRemoteEndpoint = (GetRemoteEndpoint)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetRemoteEndpoint.class);
                EJaxbEndpointType res = this.getRemoteEndpoint(getRemoteEndpoint.getEndpointName(), getRemoteEndpoint.getNodesAlreadyInvoked());
                GetRemoteEndpointResponse getRemoteEndpointResponse = this.factory.createGetRemoteEndpointResponse();
                getRemoteEndpointResponse.setEndpoint(res);
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)getRemoteEndpointResponse);
                MessageUtil.getInstance();
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (doc.getRootElement() != null && doc.getRootElement().getName().equals("addEndpoint")) {
                log.finest("ADD ENDPOINT METHOD");
                AddEndpoint addEndpoint = (AddEndpoint)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), AddEndpoint.class);
                boolean res = this.addEndpoint(addEndpoint.getEndpoint());
                AddEndpointResponse addEndpointResponse = this.factory.createAddEndpointResponse();
                addEndpointResponse.setResult(res);
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)addEndpointResponse);
                MessageUtil.getInstance();
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (doc.getRootElement() != null && doc.getRootElement().getName().equals("addNeighBourNode")) {
                log.finest("ADD NEIGHBOUR NODE METHOD");
                AddNeighBourNode addNeighBourNode = (AddNeighBourNode)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), AddNeighBourNode.class);
                boolean res = this.addNeighBourNode(addNeighBourNode.getNeighBourNode());
                AddNeighBourNodeResponse addNeighBourNodeResponse = this.factory.createAddNeighBourNodeResponse();
                addNeighBourNodeResponse.setOut(res);
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)addNeighBourNodeResponse);
                MessageUtil.getInstance();
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            }
        }
        catch (SOAException e) {
            throw new TransportException((Throwable)e);
        }
        catch (RegistryFault_Exception e) {
            try {
                org.w3c.dom.Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)e.getFaultInfo());
                org.w3c.dom.Document fault = SOAPHandler.createSoapFault((org.w3c.dom.Document)docEx);
                MessageUtil.getInstance();
                MessageUtil.getInstance().createErrorMessageStructure(exchange);
                exchange.getMessageError().getBody().setPayload(fault);
                log.finest("ERROR EX: " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (SOAException ex) {
                throw new TransportException((Throwable)ex);
            }
            catch (SOAPException ex) {
                throw new TransportException((Throwable)ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EJaxbEndpointType getRemoteEndpoint(QName endpointName, EJaxbQNameListType nodesAlreadyInvoked) throws RegistryFault_Exception {
        EJaxbEndpointType res = null;
        String trace = "";
        try {
            if (nodesAlreadyInvoked == null) {
                nodesAlreadyInvoked = new EJaxbQNameListType();
            }
            if (nodesAlreadyInvoked.getName().contains(this.getEndpointQName())) return res;
            nodesAlreadyInvoked.getName().add(this.getEndpointQName());
            log.fine("find in localEndpoints List in registry");
            Endpoint<? extends EndpointType> localEndpoint = this.localEndpoints.get(endpointName);
            if (localEndpoint == null) {
                log.fine("find in remoteEndpoints List in registry");
                EndpointType remoteEndPointInCache = this.remoteEndpoints.get(endpointName);
                if (remoteEndPointInCache == null) {
                    log.fine("find in remoteEndpoints in other nodes");
                    Object remoteEndPoint = null;
                    for (Map.Entry<QName, BasicNodeInformationsType> entry : this.neighbourNodes.entrySet()) {
                        if (nodesAlreadyInvoked.getName().contains(entry.getKey())) continue;
                        try {
                            Exchange exchange = ((ClientEndpoint)this.getEndpoint()).getStub().createExchange();
                            exchange.setDestination(new QName(entry.getKey().getNamespaceURI(), "registryEndpoint_" + entry.getKey().getLocalPart()));
                            exchange.setPattern(PatternType.IN_OUT);
                            exchange.setStatus(StatusType.ACTIVE);
                            exchange.setInterfaceName(new QName(entry.getKey().getNamespaceURI(), "registryEndpointBehaviourItf"));
                            exchange.setOperation(new QName(entry.getKey().getNamespaceURI(), "getRemoteEndpoint").toString());
                            GetRemoteEndpoint request = this.factory.createGetRemoteEndpoint();
                            request.setEndpointName(endpointName);
                            request.setNodesAlreadyInvoked(nodesAlreadyInvoked);
                            org.w3c.dom.Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)request);
                            MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
                            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                            msgIn.setBody(body);
                            exchange.setMessageIn(msgIn);
                            exchange.getMessageIn().getBody().setPayload(doc);
                            Exchange responseExchange = ((ClientEndpoint)this.getEndpoint()).sendSync(exchange, 0L);
                            GetRemoteEndpointResponse response = (GetRemoteEndpointResponse)SOAJAXBContext.getInstance().marshallAnyType(responseExchange.getMessageOut().getBody().getPayload(), GetRemoteEndpointResponse.class);
                            if (response.getEndpoint() == null) continue;
                            remoteEndPoint = response.getEndpoint();
                            break;
                        }
                        catch (ExchangeException e) {
                            trace = String.valueOf(ErrorUtil.printStackTrace((Throwable)e)) + "\n";
                        }
                        catch (TransportException e) {
                            trace = String.valueOf(ErrorUtil.printStackTrace((Throwable)e)) + "\n";
                        }
                        catch (SOAException e) {
                            trace = String.valueOf(ErrorUtil.printStackTrace((Throwable)e)) + "\n";
                        }
                    }
                    if (remoteEndPoint == null) {
                        log.fine("Endpoint unknown: " + endpointName);
                        return res;
                    } else {
                        res = remoteEndPoint;
                        EndpointType re = null;
                        if (remoteEndPoint instanceof EJaxbProviderEndpointType) {
                            re = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(remoteEndPoint, ProviderEndpointType.class);
                        } else if (remoteEndPoint instanceof EJaxbClientEndpointType) {
                            re = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(remoteEndPoint, ClientEndpointType.class);
                        } else if (remoteEndPoint instanceof EJaxbProviderProxyEndpointType) {
                            re = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(remoteEndPoint, ProviderProxyEndpointType.class);
                        } else {
                            if (!(remoteEndPoint instanceof EJaxbClientProxyEndpointType)) throw new ESBException("Undefined type: " + remoteEndPoint.getClass());
                            re = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(remoteEndPoint, ClientProxyEndpointType.class);
                        }
                        this.remoteEndpoints.put(remoteEndPoint.getName(), re);
                        if (!remoteEndPoint.getBasicNodeInformations().getTransporterList().getTransporter().contains(EJaxbTransporterType.SOAP_TRANSPORTER)) throw new ESBException("No transport found on node \"" + remoteEndPoint.getNode() + "\" so It is impossible to communicate with it");
                        if ((SOAPTransporterImpl)this.getEndpoint().getNode().getTransportersManager().getTransporter(SOAPTransporterImpl.class) == null) throw new ESBException("No transport found on node \"" + remoteEndPoint.getNode() + "\" so It is impossible to communicate with it");
                        ((SOAPTransporterImpl)this.getEndpoint().getNode().getTransportersManager().getTransporter(SOAPTransporterImpl.class)).getListOfTransporters().put(remoteEndPoint.getNode(), MessageUtil.getInstance().getSOAPTransporterAddress(remoteEndPoint.getBasicNodeInformations().getHost(), remoteEndPoint.getBasicNodeInformations().getPort()));
                    }
                    return res;
                }
                log.fine("Remote Endpoint found in registry");
                return (EJaxbEndpointType)remoteEndPointInCache.getModelObject();
            }
            log.fine("Local Endpoint found in registry");
            return (EJaxbEndpointType)localEndpoint.getModel().getModelObject();
        }
        catch (ESBException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(String.valueOf(ErrorUtil.printStackTrace((Throwable)e)) + "\n" + trace);
            RegistryFault_Exception ex = new RegistryFault_Exception(fault.getMsg(), fault);
            throw ex;
        }
    }

    public boolean addNeighBourNode(EJaxbBasicNodeInformationsType nodeInfo) throws RegistryFault_Exception {
        boolean res = false;
        try {
            if (!nodeInfo.getTransporterList().getTransporter().contains(EJaxbTransporterType.SOAP_TRANSPORTER) || (SOAPTransporterImpl)this.getEndpoint().getNode().getTransportersManager().getTransporter(SOAPTransporterImpl.class) == null) {
                RegistryFault fault = new RegistryFault();
                fault.setMsg("No transport found on node \"" + nodeInfo.getNodeName() + "\". so It is impossible to communicate with it: " + nodeInfo.getTransporterList().getTransporter());
                RegistryFault_Exception ex = new RegistryFault_Exception(fault.getMsg(), fault);
                throw ex;
            }
            ((SOAPTransporterImpl)this.getEndpoint().getNode().getTransportersManager().getTransporter(SOAPTransporterImpl.class)).getListOfTransporters().put(nodeInfo.getNodeName(), MessageUtil.getInstance().getSOAPTransporterAddress(nodeInfo.getHost(), nodeInfo.getPort()));
            EndpointType remoteRegistryEndpoint = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(RegistryEndpointType.class);
            remoteRegistryEndpoint.setName(new QName(nodeInfo.getNodeName().getNamespaceURI(), "registryEndpoint_" + nodeInfo.getNodeName().getLocalPart()));
            remoteRegistryEndpoint.setNode(nodeInfo.getNodeName());
            remoteRegistryEndpoint.setBehavioursList((BehavioursList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
            remoteRegistryEndpoint.getBehavioursList().addBehaviour(RegistryEndpointBehaviourImpl.class.getName());
            this.remoteEndpoints.put(remoteRegistryEndpoint.getName(), remoteRegistryEndpoint);
            BasicNodeInformations basicNodeInformations = (BasicNodeInformations)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)nodeInfo, BasicNodeInformations.class);
            NeighbourNode neighBourNode = (NeighbourNode)basicNodeInformations.duplicateXmlObjectAs(NeighbourNode.class);
            this.neighbourNodes.put(nodeInfo.getNodeName(), (BasicNodeInformationsType)neighBourNode);
            neighBourNode.setTransporterList((TransporterList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(TransporterList.class));
            neighBourNode.getTransporterList().addTransporter(TransporterType.SOAP_TRANSPORTER);
            ((RegistryEndpointType)this.getEndpoint().getModel()).addNeighbourNode(neighBourNode);
            res = true;
        }
        catch (ESBException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        return res;
    }

    public boolean addEndpoint(EJaxbEndpointType endpoint) throws RegistryFault_Exception {
        boolean res = false;
        try {
            Class<?> modelType;
            endpoint.setNode(this.getNodeQName());
            endpoint.setBasicNodeInformations((EJaxbBasicNodeInformationsType)((NodeType)this.endpoint.getNode().getModel()).getBasicNodeInformations().getModelObject());
            EndpointType model = null;
            Service parent = null;
            if (endpoint instanceof EJaxbComponentType) {
                model = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, ComponentType.class);
                parent = this.getEndpoint().getNode();
            } else if (endpoint instanceof EJaxbBusinessServiceType) {
                model = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, com.ebmwebsourcing.easyesb.soa10.api.element.BusinessService.class);
                parent = this.getLocalEndpoint(((EJaxbBusinessServiceType)endpoint).getComponentParent());
                if (parent == null) {
                    parent = this.endpoint.getNode();
                }
            } else if (endpoint instanceof EJaxbTechnicalServiceType) {
                modelType = Class.forName(endpoint.getType());
                model = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, modelType);
                parent = this.getLocalEndpoint(((EJaxbTechnicalServiceType)endpoint).getComponentParent());
                if (parent == null) {
                    parent = this.endpoint.getNode();
                }
            } else if (endpoint instanceof EJaxbProviderEndpointType || endpoint instanceof EJaxbProviderProxyEndpointType) {
                if (endpoint instanceof EJaxbProviderProxyEndpointType) {
                    model = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, ProviderProxyEndpoint.class);
                } else {
                    modelType = Class.forName(endpoint.getType());
                    model = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, modelType);
                }
                parent = (Service)this.getLocalEndpoint(((EJaxbProviderEndpointType)endpoint).getServiceName());
            } else if (endpoint instanceof EJaxbClientEndpointType || endpoint instanceof EJaxbClientProxyEndpointType) {
                model = endpoint instanceof EJaxbClientProxyEndpointType ? (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, ClientProxyEndpoint.class) : (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint, com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpoint.class);
                parent = this.endpoint.getNode();
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("model", model);
            context.put("parent", parent);
            System.out.println("create sca component: " + endpoint.getName() + " => " + endpoint.getType());
            org.objectweb.fractal.api.Component providerComponent = SCAHelper.getSCAHelper().createNewComponent(endpoint.getType(), context);
            SCAHelper.getSCAHelper().startComponent(providerComponent);
            if (endpoint.getName() != null) {
                SCAHelper.getSCAHelper().changeName(providerComponent, endpoint.getName().toString());
            }
            Endpoint ep = (Endpoint)providerComponent.getFcInterface("service");
            BasicNodeInformations sourceNode = (BasicNodeInformations)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)endpoint.getBasicNodeInformations(), BasicNodeInformations.class);
            ep.setNode(this.getEndpoint().getNode());
            if (endpoint instanceof EJaxbComponentType) {
                SCAHelper.getSCAHelper().addComponent(ep.getComponent(), this.getEndpoint().getNode().getComponent(), null);
                ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponents().add((Component)ep);
                if (ep.getModel().getEndpointInitialContext() != null && ep.getModel().getEndpointInitialContext().getNumberOfThreads() > 0) {
                    Map<QName, Endpoint> endpoints = Collections.synchronizedMap(new HashMap());
                    endpoints.put(ep.getQName(), ep);
                    ep.setListenersManager((ListenersManager)new ListenersManagerImpl(ep.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
                } else {
                    this.getEndpoint().getNode().getListenedEndpoints().put(ep.getQName(), ep);
                }
            } else if (endpoint instanceof EJaxbBusinessServiceType) {
                for (EJaxbProviderEndpointType pep : ((EJaxbBusinessServiceType)endpoint).getProviderEndpointsGroupList().getProviderEndpointGroup()) {
                    pep.setNode(this.getNodeQName());
                    pep.setBasicNodeInformations((EJaxbBasicNodeInformationsType)((NodeType)this.endpoint.getNode().getModel()).getBasicNodeInformations().getModelObject());
                }
                ((BusinessServiceType)((BusinessService)ep).getModel()).setProviderEndpointsGroupList((ProviderEndpointsGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));
                SCAHelper.getSCAHelper().addComponent(ep.getComponent(), parent.getComponent(), null);
                ((ComponentBehaviour)parent.findBehaviour(ComponentBehaviour.class)).addService((Service)ep);
            } else if (endpoint instanceof EJaxbTechnicalServiceType) {
                for (EJaxbProviderEndpointType pep : ((EJaxbTechnicalServiceType)endpoint).getProviderEndpointsGroupList().getProviderEndpointGroup()) {
                    pep.setNode(this.getNodeQName());
                    pep.setBasicNodeInformations((EJaxbBasicNodeInformationsType)((NodeType)this.endpoint.getNode().getModel()).getBasicNodeInformations().getModelObject());
                }
                SCAHelper.getSCAHelper().addComponent(ep.getComponent(), parent.getComponent(), null);
                ((ComponentBehaviour)parent.findBehaviour(ComponentBehaviour.class)).addService((Service)ep);
            } else if (endpoint instanceof EJaxbProviderEndpointType || endpoint instanceof EJaxbProviderProxyEndpointType) {
                ProviderEndpoint pep = (ProviderEndpoint)((SCAContentController)ep.getComponent().getFcInterface("/sca-content-controller")).getFcContent();
                pep.setServiceProvider(parent);
                if (parent != null) {
                    if (this.getEndpoint().getComponent() != null) {
                        SCAHelper.getSCAHelper().addComponent(ep.getComponent(), parent.getComponent(), null);
                    }
                    ((ServiceBehaviour)parent.findBehaviour(ServiceBehaviour.class)).getProviderEndpoints().add(pep);
                }
                if (ep.getModel().getEndpointInitialContext() != null && ep.getModel().getEndpointInitialContext().getNumberOfThreads() > 0) {
                    Map<QName, Endpoint> endpoints = Collections.synchronizedMap(new HashMap());
                    endpoints.put(ep.getQName(), ep);
                    ep.setListenersManager((ListenersManager)new ListenersManagerImpl(ep.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
                } else {
                    this.getEndpoint().getNode().getListenedEndpoints().put(ep.getQName(), ep);
                }
            } else if (endpoint instanceof EJaxbClientEndpointType || endpoint instanceof EJaxbClientProxyEndpointType) {
                SCAHelper.getSCAHelper().addComponent(ep.getComponent(), this.getEndpoint().getNode().getComponent(), null);
                ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getClientEndpoints().add((ClientEndpoint)ep);
                if (ep.getModel().getEndpointInitialContext() != null && ep.getModel().getEndpointInitialContext().getNumberOfThreads() > 0) {
                    Map<QName, Endpoint> endpoints = Collections.synchronizedMap(new HashMap());
                    endpoints.put(ep.getQName(), ep);
                    ep.setListenersManager((ListenersManager)new ListenersManagerImpl(ep.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
                } else {
                    this.getEndpoint().getNode().getListenedEndpoints().put(ep.getQName(), ep);
                }
                if (!sourceNode.getNodeName().equals(this.getEndpoint().getNode().getQName())) {
                    this.addNeighBourNode((EJaxbBasicNodeInformationsType)sourceNode.getModelObject());
                }
            }
            ep.init();
            this.localEndpoints.put(ep.getQName(), (Endpoint<? extends EndpointType>)ep);
            ((RegistryEndpointType)this.getEndpoint().getModel()).getLocalEndpointsList().addEndpoint(ep.getModel());
            res = true;
        }
        catch (SCAException e) {
            e.printStackTrace();
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        catch (NoSuchInterfaceException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        catch (ESBException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        catch (ClassNotFoundException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        catch (ContentInstantiationException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        return res;
    }

    public EJaxbBasicNodeInformationsType getNeighBourNode(QName nodeName) throws RegistryFault_Exception {
        BasicNodeInformationsType basicNode = this.neighbourNodes.get(nodeName);
        if (basicNode != null) {
            return (EJaxbBasicNodeInformationsType)basicNode.getModelObject();
        }
        return null;
    }

    public EndpointType removeEndpoint(EndpointType endpoint) throws RegistryFault_Exception {
        EndpointType res = null;
        try {
            Endpoint<? extends EndpointType> ep = this.getLocalEndpoint(endpoint.getName());
            if (endpoint instanceof ProviderEndpointType || endpoint instanceof ProviderProxyEndpointType) {
                Service service = (Service)this.getLocalEndpoint(((ProviderEndpointType)endpoint).getService());
                ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).removeProviderEndpoint((ProviderEndpoint)ep);
            } else if (endpoint instanceof ClientEndpointType || endpoint instanceof ClientProxyEndpointType) {
                Node node = this.endpoint.getNode();
                ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).removeClientEndpoint((ClientEndpoint)ep);
            } else if (endpoint instanceof ComponentType) {
                Node node = this.endpoint.getNode();
                ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).removeComponent((Component)ep);
            } else if (endpoint instanceof BusinessServiceType) {
                Component component = (Component)this.getLocalEndpoint(((BusinessServiceType)endpoint).getComponentParent());
                ((ComponentBehaviour)component.findBehaviour(ComponentBehaviour.class)).removeService((Service)ep);
            } else if (endpoint instanceof TechnicalServiceType) {
                Component component = (Component)this.getLocalEndpoint(((TechnicalServiceType)endpoint).getComponentParent());
                ((ComponentBehaviour)component.findBehaviour(ComponentBehaviour.class)).removeService((Service)ep);
            }
        }
        catch (ESBException e) {
            RegistryFault fault = new RegistryFault();
            fault.setMsg(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new RegistryFault_Exception(fault.getMsg(), fault);
        }
        return res;
    }

    public Endpoint<? extends EndpointType> removeLocalEndpoint(Endpoint<? extends EndpointType> ep) {
        Endpoint<? extends EndpointType> res = null;
        res = this.getLocalEndpoint(ep.getQName());
        this.localEndpoints.remove(res);
        ((RegistryEndpointType)this.endpoint.getModel()).getLocalEndpointsList().removeEndpoint(res.getModel());
        return res;
    }

    public Map<QName, EndpointType> getRemoteEndpoints() {
        return this.remoteEndpoints;
    }

    public void removeEndpoint(Holder<EJaxbEndpointType> endpointHolder) throws RegistryFault_Exception {
        this.removeEndpoint((EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(endpointHolder.value, EndpointType.class));
    }

    public EndpointType getEndpoint(URI address) throws ESBException {
        EndpointType res = null;
        log.finest("actual node: " + this.getEndpoint().getNode().getQName());
        log.finest("find endpoint: " + address);
        try {
            EndpointAddress epr = ESBUtil.analyzeURI((URI)address);
            EJaxbEndpointType remoteEndpoint = this.getRemoteEndpoint(new QName(epr.getNamespace(), epr.getEndpointname()), null);
            if (remoteEndpoint != null) {
                res = (EndpointType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)remoteEndpoint, EndpointType.class);
            }
        }
        catch (SOAException e) {
            throw new ESBException((Throwable)e);
        }
        catch (RegistryFault_Exception e) {
            throw new ESBException((Throwable)e);
        }
        return res;
    }

    public Endpoint<? extends EndpointType> getLocalEndpoint(URI address) throws ESBException {
        Endpoint<? extends EndpointType> res = null;
        EndpointAddress epr = null;
        try {
            epr = ESBUtil.analyzeURI((URI)address);
        }
        catch (SOAException e) {
            throw new ESBException((Throwable)e);
        }
        res = this.localEndpoints.get(new QName(epr.getNamespace(), epr.getEndpointname()));
        return res;
    }
}

