/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.registry.impl.endpoint;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryEndpointType;

@Scope("COMPOSITE")
@Service(value=RegistryEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class RegistryEndpointImpl<M extends RegistryEndpointType> extends ProviderEndpointImpl<M> implements RegistryEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
//	private static Logger log = Logger.getLogger(RegistryImpl.class.getName());
	
	// only used by frascati
	public RegistryEndpointImpl() throws ESBException {
		super();
	}
	
	public RegistryEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}

}
