/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.registry.impl.service;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.impl.service.TechnicalServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;

@Scope("COMPOSITE")
@Service(value=RegistryService.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class RegistryServiceImpl<M extends RegistryServiceType> extends TechnicalServiceImpl<M> implements RegistryService<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// only used by frascati
	public RegistryServiceImpl() throws ESBException {
		super();
	}
	
	public RegistryServiceImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}

}
