package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.cli.impl.command.AddNeighbourNodeCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.BindCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ConnectCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ConnectToGovernanceCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.DeployCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ExitCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ExportCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ExposeCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.HelpCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ProxifyCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.ESBScriptCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.SendSoapRequestCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.AdminManagementClient;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.esstar.management.UserManagementClient;



public class ESBCommandManager extends AbstractCommandManager {



	/**
	 * 
	 * @param node 
	 * @param petalsService
	 * @param petalsServer
	 * @throws ESBException 
	 * @throws ConnectionErrorException
	 * @throws PetalsAdminServiceErrorException
	 * @throws PetalsAdminDoesNotExistException
	 */
	public ESBCommandManager() throws ESBException {
		super();
	}

	@Override
	public void init(String host) throws ESBException {

		this.connectionAddress = host;

		AdminManagementClientSOAP adminClient = new AdminManagementClientSOAP(this.connectionAddress);
		UserManagementClient userClient = new UserManagementClient(this.connectionAddress);
		AdminClient baseClient = new AdminClientImpl(this.connectionAddress);

		// create the commands
		this.map.clear();
		addCommand(new ConnectCommand(this));
		addCommand(new HelpCommand(this));
		addCommand(new ExitCommand(this));

		if(this.connectionAddress != null) {
			addCommand(new ESBScriptCommand(userClient, this));
			addCommand(new ExportCommand(userClient, this));
			addCommand(new BindCommand(userClient));
			addCommand(new ExposeCommand(userClient));
			addCommand(new ProxifyCommand(userClient));
			addCommand(new DeployCommand(userClient));
			addCommand(new AddNeighbourNodeCommand(baseClient));
			addCommand(new ConnectToGovernanceCommand(baseClient));
			addCommand(new SendSoapRequestCommand(userClient));
		} else {
			
		}
	}

}
