/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl.command;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import esstar.petalslink.com.data.management.user._1.Ping;
import esstar.petalslink.com.data.management.user._1.PingResponse;
import java.util.List;

public class ConnectCommand
extends AbstractCommand<UserManagementClient> {
    private AbstractCommandManager cr;
    private String address = null;

    public ConnectCommand(AbstractCommandManager cr) throws ESBException {
        super(null);
        this.setShortcut("c");
        this.setDescription("connect");
        this.setName("Connect");
        this.cr = cr;
    }

    @Override
    public void execute() {
        try {
            UserManagementClient client = new UserManagementClient(this.address);
            Ping parameters = new Ping();
            PingResponse res = client.ping(parameters);
            this.setResult("Connection ok " + res.getNodeInformation().getName() + ", " + res.getNodeInformation().getVersion());
            this.resultCode = 1;
            this.cr.init(this.address);
        }
        catch (Throwable e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
            try {
                this.cr.init(null);
            }
            catch (ESBException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    protected int doProcess(List<String> args) {
        this.address = args.get(0);
        this.execute();
        return 1;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        if (args == null) {
            return false;
        }
        return args.size() == 1;
    }

    @Override
    public int process(List<String> args) {
        int result = 1;
        result = !this.validateArgs(args) ? -2 : this.doProcess(args);
        System.out.println(this.getResult());
        return result;
    }

    public String toString() {
        return "c <host> \t\t\t\t\t\t{Connect to ESB node via admin service}";
    }
}

