package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;

public class DeployCommand extends AbstractCommand<UserManagementClient> {

	private String mainResource;

	private List<String> resources;

	public DeployCommand(UserManagementClient client) throws ESBException {
		super(client);
		resources = new ArrayList<String>();
		this.setName("Deploy");
		this.setShortcut("d");
		this.setDescription("deploy");
	}


	@Override
	public void execute() {

		try {

			EJaxbDeploy parameters = new EJaxbDeploy();
			EJaxbDescriptorType artifact = new EJaxbDescriptorType();
			// TODO: uncomment line below when is supported
			//artifact.setAttachment(new DataHandler(new File(this.mainResource).toURI().toURL()));
			artifact.setFileURI(new File(mainResource).toURI().toString());

			parameters.setMainResource(artifact);

			for(String s : this.resources){

				EJaxbDescriptorType resource = new EJaxbDescriptorType();
				// TODO: uncomment line below when is supported
				//resource.setAttachment(new DataHandler(new File(s).toURI().toURL()));
				resource.setFileURI(new File(s).toURI().toString());
				parameters.getResources().add(resource);

			}


			EJaxbDeployResponse res = this.getClient().deploy(parameters);

			this.setResult("deployment ok "+new File(this.mainResource).getName());
			this.resultCode = AbstractCommand.OK_CODE;


		} catch (Throwable e) {
			this.setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
		}

	}

	@Override
	protected int doProcess(List<String> args) {
		this.mainResource = args.get(0);
		if(args.size()>1){
			for(int i=1 ; i < args.size() ; i++){
				this.resources.add(args.get(i));
			}
		}
		execute();
		this.mainResource = null;
		this.resources.clear();
		return resultCode;

	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() > 0 ) return true;
		return false;
	}

	@Override
	public String toString() {
		return "d <main-resource> [<resource> ...] \t\t\t{Deploy resource (bpel) on ESB node}";
	}

}
