package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;

import esstar.petalslink.com.service.management._1_0.ManagementException;

public abstract class AbstractScriptCommand<C> extends AbstractCommand<C> {

	private File confFile;

	protected AbstractCommandManager cm;

	public AbstractScriptCommand(C client, AbstractCommandManager cm) throws ESBException {
		super(client);
		this.setName("ConfParser");
		this.setDescription("Parse a XML Script file to execute administration commands.");
		this.setShortcut("s");
		this.cm = cm;
		this.setResult("");
	}

	@Override
	public void execute() {
		try {
			if(this.confFile != null && this.confFile.exists()){

				SAXBuilder builder = new SAXBuilder(false);

				Document jdom =	builder.build(confFile);
				Element element = jdom.getRootElement();

				List servicesChildren = element.getChildren("Service", Command.NAMESPACE_JDOM);
				for(int i=0 ; i<servicesChildren.size() ; i++){
					Element e = (Element) servicesChildren.get(i);
					parseService(e);
				}
				this.resultCode = 1;
			}
		} catch (JDOMException e) {
			this.setResult(e.getLocalizedMessage());
			this.resultCode = -1;

		} catch (IOException e) {
			this.setResult(e.getLocalizedMessage());
			this.resultCode = -1;
		} finally{

		}

	}

	private void parseService(Element e) {
		List<String> address = new ArrayList<String>();
		address.add(e.getAttributeValue("url"));
		try{
			AbstractCommand connect = (AbstractCommand) this.cm.findCommand("c");
			int cres = connect.process(address);
			if(cres != AbstractCommand.OK_CODE){
				this.resultCode = cres;
				return;
			}
			this.client = (C) ((AbstractScriptCommand)this.cm.findCommand("s")).getClient();
		} catch (Exception ex) {
			this.setResult(ex.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
		}

		List actions = e.getChildren("Action", Command.NAMESPACE_JDOM);
		for(int i=0 ; i<actions.size() ; i++){
			try {
				parseAction((Element)actions.get(i));
			} catch (ManagementException e1) {
				System.err.println("Error while parsing action!!!");
			}
		}
	}

	private void parseAction(Element action) throws ManagementException {
		Element command = (Element) action.getChildren().get(0);
		if(command == null) {
			System.err.println("Error while parsing command!!!");
			return;
		}

		String res = null;

		res = executeAction(command);

		if(this.getResult() == null){
			this.setResult(res);
		}else{
			this.setResult(this.getResult()+"\n"+res);
		}

	}
	
	public abstract String executeAction(Element command);


	@Override
	public int doProcess(List<String> args) {
		int res = AbstractCommand.OK_CODE;

		this.confFile = new File(args.get(0));
		try {
			System.out.println("Script found: " + this.confFile.getCanonicalPath());
		} catch (IOException e) {
			// do nothing
			e.printStackTrace();
		}
		execute();
		res = this.resultCode;

		return res;
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args == null) return false;
		if(args.size() != 1) return false;
		return true;
	}

	public int process(List<String> args) {
		this.setResult(null);
		int result = OK_CODE;
		if (!validateArgs(args)) {
			result = INVALID_ARGS;
		}else{
			result = doProcess(args);
		}
		System.out.println(this.getResult());
		return result;
	}

	@Override
	public String toString() {
		return "s <conf-file> \t\t\t\t\t{Parse Configuration Script File}";
	}

}
