/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl.command;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import java.util.List;

public class BindCommand
extends AbstractCommand<UserManagementClient> {
    private String url;
    private String wsdl;

    public BindCommand(UserManagementClient client) throws ESBException {
        super(client);
        this.setName("Bind");
        this.setDescription("Bind WS to node");
        this.setShortcut("b");
    }

    @Override
    public void execute() {
        try {
            String res = ((UserManagementClient)this.getClient()).bind(this.url, this.wsdl);
            this.setResult(res);
            this.resultCode = 1;
        }
        catch (Throwable e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    @Override
    protected int doProcess(List<String> args) {
        this.url = args.get(0);
        this.wsdl = args.get(1);
        this.execute();
        return this.resultCode;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        return args.size() == 2;
    }

    public String toString() {
        return "b <url> <wsdl> \t\t\t\t\t{Bind/Import Web Service (SOAP) in the ESB node}";
    }
}

