package com.ebmwebsourcing.easyesb.cli.impl;




import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;


public abstract class AbstractClientLauncher {

	private String banner = null;

	private final static String LOGGER_FILE = "/logger/easyesb-logging.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = AbstractClientLauncher.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}




	private AbstractCommandManager console = null;

	/**
	 * Default constructor
	 * @throws ESBException 
	 */
	public AbstractClientLauncher(AbstractCommandManager cm) throws ESBException {
		this.console = cm;
	}
	
	public AbstractCommandManager getConsole() {
		return console;
	}

	public void setConsole(AbstractCommandManager console) {
		this.console = console;
	}
	
	public String getBanner() {
		if(this.banner == null) {
			this.banner =  " -----------------------------------------------------------\n" +
					"|                                                           |\n" +
					"|                          " + getDistributionName() + "                          |\n" +
					"|             EBM Research Enterprise Service Bus           |\n" +
					"|               http://research.petalslink.org              |\n" +
					"|                                                           |\n" +
					" -----------------------------------------------------------\n";
		}
		return this.banner;
	}

	/**
	 * 
	 */
	protected void showBanner() {
		System.out.println();
		System.out
		.println(this.getBanner());
		System.out.println();
	}

	public void setBanner(String banner) {
		this.banner = banner;
	}

	/**
	 * The main program
	 * 
	 * @param args
	 */
	public void launch(String[] args) {
		this.showBanner();
		List<String> command = new ArrayList<String>();



		for (String arg : args) {
			command.add(arg);
		}

		try {

				System.out.println(getDistributionName() + " is starting...");
				System.out.println(getDistributionName() + " prompt. Tape 'h' for help.");
				

				// show the commandLine mode if asked
				this.commandLineMode(command);
			
		} catch (Throwable e) {
			System.out.println("Command processing error : " + command);
			e.printStackTrace(System.err);
			System.exit(-1);
		}

	}


	/*
	 * (non-Javadoc)
	 * 
	 */
	public void version() throws Exception {
		System.out.println("No version");
	}

	/**
	 * Print the launcher usage
	 */
	protected void printUsage() {
		this.console.printUsage();
	}

	/**
	 * To be overrided for specific message
	 */
	protected void printSpecificStartMessage() {
	}

	/**
	 * Show a command line to interact with Petals. TODO we pass the PetalsAdmin
	 * object to the CommandReader to perform some actions. Find a better way.
	 * 
	 * @param node
	 * 
	 * @throws Exception
	 */
	protected void commandLineMode(List<String> commands) throws Exception {
		if(commands.size()==0){
			console.read();
		} else{
			List<String> command = console.detectCommand(commands);
			for(String com : command){
				console.processCommandLine(com);
			}
			
		}
	}


	/**
	 * Get the distribution name
	 * 
	 * @return
	 */
	public abstract String getDistributionName();

}
