package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.util.List;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.AdminManagementClient;
import com.ebmwebsourcing.esstar.management.UserManagementClient;

import esstar.petalslink.com.data.management.admin._1.Ping;
import esstar.petalslink.com.data.management.admin._1.PingResponse;

public class ConnectCommand extends AbstractCommand<UserManagementClient> {

	private AbstractCommandManager cr;
	
	private String address = null;
	
	public ConnectCommand(AbstractCommandManager cr) throws ESBException {
		super(null);
		this.setShortcut("c");
		this.setDescription("connect");
		this.setName("Connect");
		this.cr = cr;

	}

	@Override
	public void execute() {
		try{
			AdminManagementClient client = new AdminManagementClient(address);
			
			Ping parameters = new Ping();
			PingResponse res = client.ping(parameters);
			this.setResult("Connection ok "+ res.getNodeInformation().getName()+", "+res.getNodeInformation().getVersion());
			this.resultCode = AbstractCommand.OK_CODE;
			this.cr.init(this.address);	
		} catch(Throwable e){
			this.setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			try {
				this.cr.init(null);
			} catch (ESBException e1) {
				// do nothing
				e1.printStackTrace();
			}
		}


	}

	@Override
	protected int doProcess(List<String> args) {
		this.address = args.get(0);
		execute();
		return AbstractCommand.OK_CODE;
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args == null) return false;
		if(args.size() != 1){
			return false;
		}
		return true;
	}

	public int process(List<String> args) {
		int result = OK_CODE;
		if (!validateArgs(args)) {
			result = INVALID_ARGS;
		}else{
			result = doProcess(args);
		}
		System.out.println(this.getResult());
		return result;
	}

	@Override
	public String toString() {
		return "c <host> \t\t\t\t\t\t{Connect to ESB node via admin service}";
	}
	
}
