/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.mycomponent;


import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.LogManager;

import javax.xml.namespace.QName;

import org.junit.Assert;
import org.junit.Test;

import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class MyComponentTest {

	static {
		try {
			InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
			LogManager.getLogManager().readConfiguration(configFile);

//			SOAJAXBContext.getInstance().addOtherObjectFactory(com.petalslink.esstar.execution_environment_synchronizer_impl._1.ObjectFactory.class,
//					org.example.fireman.ObjectFactory.class);
		} catch (Exception ex)
		{
			System.out.println("WARNING: Could not open configuration file");
			System.out.println("WARNING: Logging not configured (console output only)");
		}
	}

	private Node createNode(final QName name, final String host, final int port, final int soap_port) throws ESBException {
		ESBFactory factory = new ESBFactoryImpl();
		Node node = factory.createNode(name, new ConfigurationImpl(host, port, new HashMap<String, String>() {{ put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));}}));
		return node;
	}

	@Test(timeout=120000)
	public void testStartMyComponentInNode() throws Exception {
		Node node = null;
		try {
			node = this.createNode(new QName("http://com.ebmwebsourcing", "esb"), "localhost", 9100, 8085);
			Assert.assertNotNull(node);
		} finally {
			if(node != null) {
				node.stop();
			}
		}
	}
	
	
	@Test//(timeout=120000)
	public void testDeployResourceOnMyComponent() throws Exception {
		Node node = null;
		try {
			node = this.createNode(new QName("http://com.ebmwebsourcing", "esb"), "localhost", 9100, 8085);
			Assert.assertNotNull(node);
			
			AdminClient client = new AdminClientImplSOAP("http://localhost:8085/services/adminExternalEndpoint");
			EJaxbDeployementReport report = client.deploy(new File("./src/test/resources/myResource.myExt").toURI().toURL());
			
			Assert.assertNotNull(report);
		} finally {
			if(node != null) {
				node.stop();
			}
		}
	}

	
	
}
