package com.ebmwebsourcing.easyesb.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SDK {


	public static void main(String[] args) throws Exception {
		SDK sdk = new SDK();

		List<String> argsList = new ArrayList<String>(Arrays.asList(args));
		List<Command> commands = sdk.analyzeArgs(argsList);

		if(commands.contains(new CommandComponentHelp(null))) {
			CommandComponentHelp help = (CommandComponentHelp) commands.get(commands.indexOf(new CommandComponentHelp(null)));
			new TaskComponentHelp(help).execute();
		} else if(commands.contains(new CommandComponentCreate())) {
			String packageName = null;
			String componentName = null;
			if(commands.contains(new CommandPackage(null))) {
				CommandPackage p = (CommandPackage) commands.get(commands.indexOf(new CommandPackage(null)));
				packageName = p.getValue();
			}
			if(commands.contains(new CommandComponentName(null))) {
				CommandComponentName cn = (CommandComponentName) commands.get(commands.indexOf(new CommandComponentName(null)));
				componentName = cn.getValue();
			}
			
			TaskCreateComponent task = new TaskCreateComponent(packageName, componentName);
			task.execute();
			System.out.println(task.getResult());
		} else {
			CommandComponentHelp help = new CommandComponentHelp("Wrong arguments: " + argsList);
			new TaskComponentHelp(help).execute();
		}
	}

	private List<Command> analyzeArgs(List<String> argsList) {
		List<Command> res = new ArrayList<Command>();

		System.out.println("Call easyesb-sdk with arguments: " + argsList);
		if(argsList.size() == 0) {
			res.add(new CommandComponentHelp(null));
		} 
		if(argsList.contains("-help")) {
			argsList.remove("-help");
			res.add(new CommandComponentHelp(null));
		} 
		if(argsList.contains("-p")) {
			if(argsList.size() > argsList.indexOf("-p") + 1) {
				String value = argsList.remove(argsList.indexOf("-p") + 1);
				System.out.println("package value = " + value);
				if(value.startsWith("-")) {
					argsList.clear();
					res.add(new CommandComponentHelp("Wrong arguments: " + argsList));
				}
				res.add(new CommandPackage(value));
				argsList.remove("-p");
			} else {
				argsList.clear();
				res.add(new CommandComponentHelp(null));
			}
		} 
		if(argsList.contains("-c")) {
			if(argsList.size() > argsList.indexOf("-c") + 1) {
				String value = argsList.remove(argsList.indexOf("-c") + 1);
				System.out.println("component name value = " + value);
				if(value.startsWith("-")) {
					argsList.clear();
					res.add(new CommandComponentHelp("Wrong arguments: " + argsList));
				}
				res.add(new CommandComponentName(value));
				argsList.remove("-p");
			} else {
				argsList.clear();
				res.add(new CommandComponentHelp(null));
			}
		} 
		if(argsList.contains("-create-component")) {
			argsList.remove("-create-component");
			res.add(new CommandComponentCreate());
		} 
		return res;
	}
}
