/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.transporter.impl.soap;

/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.util.Util;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbExchangeType;
import easyesb.petalslink.com.transporter._1.ObjectFactory;
import easyesb.petalslink.com.transporter._1.PullRequest;
import easyesb.petalslink.com.transporter._1.PullWithId;
import easyesb.petalslink.com.transporter._1.PushRequest;
import easyesb.petalslink.com.transporter._1.TransportExceptionElement;
import easyesb.petalslink.com.transporter._1_0.TransportExceptionFault;
import easyesb.petalslink.com.transporter._1_0.Transporter;

/**
 * This class was generated by Apache CXF 2.1.4
 * Sat Jul 04 22:13:09 CEST 2009
 * Generated source version: 2.1.4
 * 
 */

public final class Transporter_TransporterSOAP_Client implements Transporter {


//	private static final Logger log = Logger.getLogger(Transporter_TransporterSOAP_Client.class.getName());

	private SOAPSender sender  = new SOAPSender();

	private Map<QName, String> listOfTransporters = new HashMap<QName, String>();

	private ObjectFactory jaxbFactory = new ObjectFactory();



	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}


	public Transporter_TransporterSOAP_Client() throws ExchangeException {
	}

	public Map<QName, String> getListOfTransporters() {
		return listOfTransporters;
	}

	public EJaxbExchangeType pullWithId(UUID id, QName providerEndpointName, QName nodeEndpointName) throws TransportExceptionFault  {
		EJaxbExchangeType _pull__return = null;
	//	log.finest("Invoking pull...");

		// find good transporter from endpoint to call

		String endpointNodeAddress = this.listOfTransporters.get(nodeEndpointName);

		//log.finest("endpointNodeAddress = " + endpointNodeAddress);

		try {

			PullWithId pullWithId = jaxbFactory.createPullWithId();
			pullWithId.setUuid(id.toString());
			pullWithId.setEndpointName(providerEndpointName.toString());

			Document message = SOAJAXBContext.getInstance().unmarshallAnyElement(pullWithId);

//			Document message = domfactory.newDocumentBuilder().newDocument();
//			org.w3c.dom.Element pullWithId = message.createElementNS(TRANSPORTER_QNAME, "pullWithId");
//			pullWithId.setPrefix("trans");
//
//			org.w3c.dom.Element uuid = message.createElement("uuid");
//			uuid.setTextContent(id.toString());
//			pullWithId.appendChild(uuid);
//
//			org.w3c.dom.Element endpointName = message.createElementNS(TRANSPORTER_QNAME, "endpointName");
//			endpointName.setPrefix("trans");
//			endpointName.setTextContent(providerEndpointName.toString());
//			pullWithId.appendChild(endpointName);
//
//			message.appendChild(pullWithId);
			message = SOAPSender.createSOAPMessageRequest(message);

			Document response = this.sender.sendSoapRequest(message, endpointNodeAddress, null);

			testIfFault(response);
			Exchange exchange = extractExchangeFromSoapResponse(response);

			_pull__return = (EJaxbExchangeType) ((Exchange)exchange).getInternalModel();
		} catch (JDOMException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (ExchangeException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (SOAPException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (SOAException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		}
		return _pull__return;
	}

	public easyesb.petalslink.com.transporter._1.PullResponse pullWithId(
			easyesb.petalslink.com.transporter._1.PullWithId parameters
	) throws TransportExceptionFault {
		throw new UnsupportedOperationException();
	}


	public easyesb.petalslink.com.transporter._1.PullResponse pull(
			easyesb.petalslink.com.transporter._1.PullRequest parameters
	) throws TransportExceptionFault {
		throw new UnsupportedOperationException();
	}


	public EJaxbExchangeType pull(QName providerEndpointName, QName nodeEndpointName) throws TransportExceptionFault   {
		EJaxbExchangeType _pull__return = null;
		//log.finest("Invoking pull...");

		// find good transporter from endpoint to call

		String endpointNodeAddress = this.listOfTransporters.get(nodeEndpointName);

		//log.finest("endpointNodeAddress = " + endpointNodeAddress);

		try {
			PullRequest pullRequest = this.jaxbFactory.createPullRequest();
			pullRequest.setEndpointName(providerEndpointName.toString());
			
			Document message = SOAJAXBContext.getInstance().unmarshallAnyElement(pullRequest);
			
//			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
//			factory.setNamespaceAware(true);
//
//			Document message = factory.newDocumentBuilder().newDocument();
//
//			org.w3c.dom.Element endpointName = message.createElementNS(TRANSPORTER_QNAME, "endpointName");
//			endpointName.setPrefix("trans");
//			endpointName.setTextContent(providerEndpointName.toString());
//
//
//			message.appendChild(endpointName);

			message = SOAPSender.createSOAPMessageRequest(message);

			Document response = this.sender.sendSoapRequest(message, endpointNodeAddress, "http://com.petalslink.easyesb/transporter/pull");

			testIfFault(response);
			Exchange exchange = extractExchangeFromSoapResponse(response);


			_pull__return = (EJaxbExchangeType) ((Exchange)exchange).getInternalModel();
		} catch (JDOMException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (ExchangeException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (SOAPException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} catch (SOAException e) {
			TransportExceptionFault ex = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			ex.getFaultInfo().setErrorMsg(e.getMessage());
			throw ex;
		} 
		return _pull__return;
	}

	private void testIfFault(Document response) throws com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException {
		NodeList bodies = response.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
		if((bodies != null)&&(bodies.getLength() == 1)) {
			NodeList faults = ((org.w3c.dom.Element)bodies.item(0)).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
			if((faults != null)&&(faults.getLength() == 1)) {
				NodeList faultstrings = ((org.w3c.dom.Element)faults.item(0)).getElementsByTagName("faultstring");
				// TODO: get details of the fault
				if((faultstrings != null)&&(faultstrings.getLength() == 1)) {
					throw new com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException(faultstrings.item(0).getNodeValue());
				}
				throw new com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException("Impossible to analyze the fault but there is a fault!!!!");
			}
		}
	}

	private Exchange extractExchangeFromSoapResponse(Document response) throws ExchangeException {
		Exchange exchange = null;
		try {


			NodeList bodies = response.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
			if((bodies != null)&&(bodies.getLength() == 1)) {
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				factory.setNamespaceAware(true);
				Document doc = factory.newDocumentBuilder().newDocument();
				doc.appendChild(doc.importNode(bodies.item(0).cloneNode(true), true));
				InputStream is = Util.convertDocumentToInputStream(doc);
				exchange = SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readFragment(is, Exchange.class);
				is.close();
			}

		} catch (ParserConfigurationException e) {
			throw new ExchangeException(e);
		} catch (XmlObjectValidationException e) {
			throw new ExchangeException(e);
		} catch (XmlObjectReadException e) {
			throw new ExchangeException(e);
		} catch (IOException e) {
			throw new ExchangeException(e);
		}

		return exchange;
	}


	public easyesb.petalslink.com.transporter._1.PushResponse push(
			easyesb.petalslink.com.transporter._1.PushRequest parameters) {
		throw new UnsupportedOperationException();
	}


	public void push(QName endpointNodeName, EJaxbExchangeType exchange) throws TransportExceptionFault {
	//	log.finest("Invoking push...");

		String endpointNodeAddress = this.listOfTransporters.get(endpointNodeName) ;

	//	log.finest("endpointAddress = " + endpointNodeAddress);

	//	Exchange ex = SOAUtil.getInstance().getXmlObjectFactory().create(Exchange.class);
		//Exchange ex = new ExchangeImpl(URI.create("."), exchange, new NamespaceMapperImpl(), new SchemaLocatorImpl());

		try {
			
			PushRequest pushRequest = this.jaxbFactory.createPushRequest();
			pushRequest.setEndpointNodeName(endpointNodeName.toString());
			pushRequest.setExchange(exchange);
			
			Document message = SOAJAXBContext.getInstance().unmarshallAnyElement(pushRequest);

			message = SOAPSender.createSOAPMessageRequest(message);

			Document res = this.sender.sendSoapRequest(message, endpointNodeAddress, "http://com.petalslink.easyesb/transporter/push");
			if(res == null) {
				String errorMsg = "Reliability Error: the message with id \"" + exchange.getUuid() + "\" is not arrive to destination: " + exchange.getDestination();
				TransportExceptionFault exception = new TransportExceptionFault(errorMsg, new TransportExceptionElement());
				exception.getFaultInfo().setErrorMsg(errorMsg);
				throw exception;
			}
		} catch (JDOMException e) {
			TransportExceptionFault exception = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			exception.getFaultInfo().setErrorMsg(e.getMessage());
			throw exception;
		} catch (SOAPException e) {
			TransportExceptionFault exception = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			exception.getFaultInfo().setErrorMsg(e.getMessage());
			throw exception;
		} catch (SOAException e) {
			TransportExceptionFault exception = new TransportExceptionFault(e.getMessage(), new TransportExceptionElement(), e);
			exception.getFaultInfo().setErrorMsg(e.getMessage());
			throw exception;
		}
	}

}
