/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.transporter.impl.soap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbExchangeType;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbStatusType;
import easyesb.petalslink.com.transporter._1.PushResponse;
import easyesb.petalslink.com.transporter._1.TransportExceptionElement;
import easyesb.petalslink.com.transporter._1_0.TransportExceptionFault;
import easyesb.petalslink.com.transporter._1_0.Transporter;

/**
 * This class was generated by Apache CXF 2.1.3
 * Sun Dec 20 00:36:27 CET 2009
 * Generated source version: 2.1.3
 * 
 */

@javax.jws.WebService(
        serviceName = "transporterService",
        portName = "TransporterImplPort",
        targetNamespace = "http://com.petalslink.easyesb/transporter/1.0",
        wsdlLocation = "wsdl/transporter10.wsdl",
        endpointInterface = "easyesb.petalslink.com.transporter._1_0.Transporter")

        public class Transporter_TransporterSOAP_Server implements Transporter {

    private static final Logger log = Logger.getLogger(Transporter_TransporterSOAP_Server.class.getName());


    private Server endpoint;

    /**
     * The maximum size of a the Java queue.
     */
    private static final int QUEUE_SIZE = 10000;

    private Map<QName, BlockingQueue<EJaxbExchangeType>> exchangeQueuesMap = new HashMap<QName, BlockingQueue<EJaxbExchangeType>>();

    public Transporter_TransporterSOAP_Server(String serverAddress) {
        log.finest("Starting transporter Server: " + serverAddress);

        endpoint = CXFHelper.getService(serverAddress, this.getClass(), this);//Endpoint.publish(address, this);
        this.start();
    }

    public String getAddress() {
    	return endpoint.getAddress();
    }
    
    public void start() {
        this.endpoint.start();
    }

    public void stop() {
        this.endpoint.stop();
    }
    
    public boolean isStopped(){
        return this.endpoint.isStopped();
    }

    /* (non-Javadoc)
     */
    public easyesb.petalslink.com.transporter._1.PushResponse push(
            easyesb.petalslink.com.transporter._1.PushRequest parameters) {
        //		log.finest("Executing operation push:");
        //		log.finest("exchange status = " + parameters.getExchange().getStatus());
        //		log.finest("exchange destination = " + parameters.getExchange().getDestination());
        //		log.finest("exchange source = " + parameters.getExchange().getSource());

        if(parameters.getEndpointNodeName() == null) {
            log.warning("Endpoint node name cannot be null");
        }

        QName queueName = parameters.getExchange().getDestination();
        if(parameters.getExchange().getStatus().equals(EJaxbStatusType.DONE) || parameters.getExchange().getStatus().equals(EJaxbStatusType.FAULT)) {
            queueName = parameters.getExchange().getSource();
        }



        BlockingQueue<EJaxbExchangeType> exchangesQueue = this.exchangeQueuesMap.get(queueName);

        if (exchangesQueue == null) {
            this.exchangeQueuesMap.put(queueName, new ArrayBlockingQueue<EJaxbExchangeType>(QUEUE_SIZE));
            exchangesQueue = this.exchangeQueuesMap.get(queueName);
        }



        if (exchangesQueue.remainingCapacity() == 0) {
            log.warning("The SOAP Transporter has reached its maximum capacity for the target component '"
                    + parameters.getEndpointNodeName() + "'. The message exchange is rejected");
        }

        exchangesQueue.offer(parameters.getExchange());
        //	log.finest("exchange " + parameters.getExchange().getUuid() + " push in queue of " + queueName); 

        return new PushResponse();
    }

    /* (non-Javadoc)
     */
    public easyesb.petalslink.com.transporter._1.PullResponse pull(
            easyesb.petalslink.com.transporter._1.PullRequest parameters
    ) throws TransportExceptionFault {
        easyesb.petalslink.com.transporter._1.PullResponse response = new easyesb.petalslink.com.transporter._1.PullResponse();
        EJaxbExchangeType res = null;
        //		log.finest("Executing operation pull on " +  parameters.getEndpointName());//providerEndpointName);
        if(parameters.getEndpointName() == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: providerEndpoint Name cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: providerEndpoint Name cannot be null");
            throw exception;
        }

        QName provider = QName.valueOf(parameters.getEndpointName());

        if(this.exchangeQueuesMap == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: the exchange queue map cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: the exchange queue map cannot be null");
            throw exception;
        }

        BlockingQueue<EJaxbExchangeType> exchangesQueue = this.exchangeQueuesMap.get(provider);

        if(exchangesQueue != null) {
            res = exchangesQueue.poll();
        }
        response.setExchange(res);

        return response;
    }

    /* (non-Javadoc)
     */
    public easyesb.petalslink.com.transporter._1.PullResponse pullWithId(
            easyesb.petalslink.com.transporter._1.PullWithId parameters
    ) throws TransportExceptionFault { 
        //	log.finest("Executing operation pullWithId on " + parameters.getEndpointName());

        if(parameters == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: parameters cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: parameters cannot be null");
            throw exception;
        }

        // pull on client queue

        if(parameters.getEndpointName() == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: The provider endpoint cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: The provider endpoint cannot be null");
            throw exception;
        }



        easyesb.petalslink.com.transporter._1.PullRequest pullRequest = new easyesb.petalslink.com.transporter._1.PullRequest();
        pullRequest.setEndpointName(parameters.getEndpointName());
        easyesb.petalslink.com.transporter._1.PullResponse response = this.pull(pullRequest);

        BlockingQueue<EJaxbExchangeType> exchangesQueue = this.exchangeQueuesMap.get(QName.valueOf(parameters.getEndpointName()));

        if(exchangesQueue == null) {
            TransportExceptionFault exception = new TransportExceptionFault("Impossible to find queue corresponding to this endpoint " + parameters.getEndpointName(), new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("Impossible to find queue corresponding to this endpoint " + parameters.getEndpointName());
            throw exception;
        }

        if(exchangesQueue != null) {
            if(parameters.getUuid() != null) {
                EJaxbExchangeType first = null;
                while((response != null)&&(response.getExchange() != null)&&(!response.getExchange().getUuid().equals(parameters.getUuid()))&&(first != response.getExchange())) {
                    if(first == null) {
                        first = response.getExchange();
                    }
                    exchangesQueue.offer(response.getExchange());
                    response = this.pull(pullRequest);
                }
            }
        }

        return response;
    }

}
