/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.transporter.impl.soap;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportContext;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.Transporter;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransportContext;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.Transporter_TransporterSOAP_Client;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.Transporter_TransporterSOAP_Server;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbExchangeType;
import easyesb.petalslink.com.transporter._1.PullRequest;
import easyesb.petalslink.com.transporter._1.PullResponse;
import easyesb.petalslink.com.transporter._1.PullWithId;
import easyesb.petalslink.com.transporter._1.PushRequest;
import easyesb.petalslink.com.transporter._1_0.TransportExceptionFault;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={Transporter.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class SOAPTransporterImpl
extends SCAComponentImpl
implements Transporter {
    private Transporter_TransporterSOAP_Client client;
    private Transporter_TransporterSOAP_Server server;
    private SOAPTransportContext context = new SOAPTransportContext();

    public SOAPTransporterImpl() throws ExchangeException {
        this.client = new Transporter_TransporterSOAP_Client();
    }

    public SOAPTransporterImpl(QName endpoint, String address) throws ExchangeException {
        this.client = new Transporter_TransporterSOAP_Client();
        SOAPTransportContext context = new SOAPTransportContext();
        context.setNodeName(endpoint);
        context.setHttpAddress(address);
        this.setContext(context);
    }

    public TransportContext getContext() {
        return this.context;
    }

    public void setContext(TransportContext context) {
        this.context = (SOAPTransportContext)context;
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        this.server = new Transporter_TransporterSOAP_Server(this.context.getHttpAddress());
    }

    public Map<QName, String> getListOfTransporters() {
        return this.client.getListOfTransporters();
    }

    public Exchange pull(QName providerEndpointName, QName nodeEndpointName) throws TransportException {
        Exchange res = null;
        EJaxbExchangeType exchange = null;
        try {
            if (providerEndpointName == null) {
                throw new TransportException("provider endpoint name cannot be null");
            }
            if (nodeEndpointName == null) {
                throw new TransportException("node name cannot be null");
            }
            if (this.context.getNodeName() == null) {
                throw new TransportException("node name cannot be null");
            }
            if (nodeEndpointName.equals(this.context.getNodeName())) {
                PullRequest pullRequest = new PullRequest();
                pullRequest.setEndpointName(providerEndpointName.toString());
                PullResponse pullResponse = this.server.pull(pullRequest);
                exchange = pullResponse.getExchange();
            } else {
                String endpointAddress = this.client.getListOfTransporters().get(nodeEndpointName);
                if (endpointAddress == null) {
                    throw new TransportException("Impossible to find transporter address to node:" + nodeEndpointName);
                }
                exchange = this.client.pull(providerEndpointName, nodeEndpointName);
            }
            if (exchange != null) {
                res = (Exchange)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)exchange, Exchange.class);
            }
        }
        catch (TransportExceptionFault e) {
            throw new TransportException((Throwable)e);
        }
        return res;
    }

    public Exchange pull(UUID uuid, QName providerEndpointName, QName nodeEndpointName) throws TransportException {
        Exchange res = null;
        EJaxbExchangeType exchange = null;
        try {
            if (providerEndpointName == null) {
                throw new TransportException("provider endpoint name cannot be null");
            }
            if (nodeEndpointName == null) {
                throw new TransportException("node name cannot be null");
            }
            if (this.context.getNodeName() == null) {
                throw new TransportException("node name cannot be null");
            }
            if (nodeEndpointName.equals(this.context.getNodeName())) {
                PullWithId _pullWithId_parameters = new PullWithId();
                _pullWithId_parameters.setUuid(uuid.toString());
                _pullWithId_parameters.setEndpointName(providerEndpointName.toString());
                PullResponse pullResponse = this.server.pullWithId(_pullWithId_parameters);
                exchange = pullResponse.getExchange();
            } else {
                String endpointAddress = this.client.getListOfTransporters().get(nodeEndpointName);
                if (endpointAddress == null) {
                    throw new TransportException("Impossible to find transporter address to node:" + nodeEndpointName);
                }
                exchange = this.client.pullWithId(uuid, providerEndpointName, nodeEndpointName);
            }
            if (exchange != null) {
                res = (Exchange)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().wrap((Object)exchange, Exchange.class);
            }
        }
        catch (TransportExceptionFault e) {
            throw new TransportException((Throwable)e);
        }
        return res;
    }

    public void push(Exchange exchange, QName endpointNodeName) throws TransportException {
        try {
            if (endpointNodeName == null) {
                throw new TransportException("endpoint name cannot be null");
            }
            if (this.context.getNodeName() == null) {
                throw new TransportException("node name cannot be null");
            }
            EJaxbExchangeType exch = (EJaxbExchangeType)exchange.getInternalModel();
            if (endpointNodeName.equals(this.context.getNodeName())) {
                PushRequest _push_parameters = new PushRequest();
                _push_parameters.setExchange(exch);
                _push_parameters.setEndpointNodeName(endpointNodeName.toString());
                this.server.push(_push_parameters);
            } else {
                this.client.push(endpointNodeName, exch);
            }
        }
        catch (TransportExceptionFault e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void stop() throws TransportException {
        this.server.stop();
    }

    public void start() throws TransportException {
        this.server.start();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }
}

