/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyevent.impl.client;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicType;
import com.petalslink.events_api._1.FindEventProducersByElements;
import com.petalslink.events_api._1.FindEventProducersByElementsResponse;
import com.petalslink.events_api._1.FindEventProducersByTopicsRequest;
import com.petalslink.events_api._1.FindEventProducersByTopicsResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.events_api._1_0.FindEventProducersByElementsFault;
import com.petalslink.events_api._1_0.FindEventProducersByTopicsFault;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;
import com.petalslink.events_api._1_0.FindTopicsFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;

public class EventManagerClientImpl implements EventsManager {

    private String address = null;

    private EventsManager clientProxy = null;

    public EventManagerClientImpl(String address) {
        this.address = address;

       
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized EventsManager getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, EventsManager.class);
        return clientProxy;
    }

    
    public String getAddress() {
        return address;
    }

	@Override
	public List<QName> findTopicsByElement(QName element)
			throws FindTopicsByElementFault {
		return this.getClientProxy().findTopicsByElement(element);
	}

	@Override
	public List<TopicType> findTopics(String request) throws FindTopicsFault {
		return this.getClientProxy().findTopics(request);
	}

	@Override
	public PublishTopicNamespaceFromDOMResponse publishTopicNamespaceFromDOM(
			PublishTopicNamespaceFromDOM parameters)
			throws PublishTopicNamespaceFromDOMFault {
		return this.getClientProxy().publishTopicNamespaceFromDOM(parameters);
	}

	@Override
	public PublishTopicNamespaceFromURLResponse publishTopicNamespaceFromURL(
			PublishTopicNamespaceFromURL parameters)
			throws PublishTopicNamespaceFromURLFault {
		return this.getClientProxy().publishTopicNamespaceFromURL(parameters);
	}

	@Override
	public FindEventProducersByTopicsResponse findEventProducersByTopics(
			FindEventProducersByTopicsRequest body)
			throws FindEventProducersByTopicsFault {
		return this.getClientProxy().findEventProducersByTopics(body);
	}

	@Override
	public FindEventProducersByElementsResponse findEventProducersByElements(
			FindEventProducersByElements parameters)
			throws FindEventProducersByElementsFault {
		return this.getClientProxy().findEventProducersByElements(parameters);
	}



}
