/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.with.WithImports;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithImportsTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_IMPORTS = "expectedImports";

    public WithImportsTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetImports() {
        WithImports imports = (WithImports)this.newXmlObjectUnderTest();
        Object[] expectedImports = (Import[])this.getTestData(EXPECTED_IMPORTS);
        Assert.assertArrayEquals((Object[])expectedImports, (Object[])imports.getImports());
    }

    @Test
    public void testAddImport() {
        WithImports imports = (WithImports)this.newXmlObjectUnderTest();
        LinkedList<Import> expectedImports = new LinkedList<Import>(Arrays.asList((Import[])this.getTestData(EXPECTED_IMPORTS)));
        Import newImport = (Import)this.getXmlContext().getXmlObjectFactory().create(Import.class);
        newImport.setId("newImportId");
        expectedImports.add(newImport);
        imports.addImport(newImport);
        Assert.assertEquals(expectedImports, Arrays.asList(imports.getImports()));
    }

    @Test
    public void testRemoveImport() {
        WithImports imports = (WithImports)this.newXmlObjectUnderTest();
        for (Import e : imports.getImports()) {
            imports.removeImport(e);
            Assert.assertFalse((boolean)Arrays.asList(imports.getImports()).contains(e));
        }
    }

    @Test
    public void testClearImports() {
        WithImports imports = (WithImports)this.newXmlObjectUnderTest();
        imports.clearImports();
        Assert.assertEquals((long)0L, (long)imports.getImports().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithImports imports = (WithImports)this.newXmlObjectUnderTest();
        Import newImport = (Import)this.getXmlContext().getXmlObjectFactory().create(Import.class);
        imports.addImport(newImport);
        Assert.assertEquals((Object)imports, (Object)newImport.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithImports imports = (WithImports)this.newXmlObjectUnderTest();
        Import newImport = (Import)this.getXmlContext().getXmlObjectFactory().create(Import.class);
        imports.addImport(newImport);
        imports.removeImport(newImport);
        Assert.assertNull((Object)newImport.getXmlObjectParent());
    }
}

