package com.ebmwebsourcing.easyschema10.api;

import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;

public final class SchemaOfSchemas {

    private static final XmlContext PRIVATE_CONTEXT;
    
    private static Schema SCHEMA_OF_SCHEMAS = null;

    
    static {

        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        // create a private context.
        PRIVATE_CONTEXT = xmlContextFactory.newContext();

        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);

        URL schemaInputStream = null;
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);

            schemaInputStream = SchemaOfSchemas.class.getClassLoader().getResource(
                    Constants.XMLSCHEMA_ORIGINATING_SCHEMA_DIR + "/" + Constants.XMLSCHEMA_ORIGINATING_SCHEMA_NAME);
            assert schemaInputStream != null;
            XmlObjectReader reader = PRIVATE_CONTEXT.createReader();

            SCHEMA_OF_SCHEMAS = reader.readDocument(schemaInputStream, Schema.class);
            
            XmlObjectFactory xmlObjectFactory = SCHEMA_OF_SCHEMAS.getXmlContext().getXmlObjectFactory();

            ComplexType anyType = xmlObjectFactory.create(ComplexType.class);
            anyType.setName("anyType");
            SCHEMA_OF_SCHEMAS.addComplexType(anyType);
        
            SimpleType anySimpleType = xmlObjectFactory.create(SimpleType.class);
            anySimpleType.setName("anySimpleType");
            SCHEMA_OF_SCHEMAS.addSimpleType(anySimpleType);
            
        } catch (Exception e) {
            throw new UncheckedException("Cannot read schema of schemas.", e);
        }
    }

    
    private SchemaOfSchemas() {
    }
    
    
    public static Schema getSchema() {
        return SCHEMA_OF_SCHEMAS;
    }
    
    
}
