/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.api.element;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.with.WithId;
import com.ebmwebsourcing.easybox.api.with.WithInferrableQName;
import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybox.api.with.WithType;
import com.ebmwebsourcing.easyschema10.api.Constants;
import com.ebmwebsourcing.easyschema10.api.SchemaXmlObject;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.with.WithAbstract;
import com.ebmwebsourcing.easyschema10.api.with.WithAnnotation;
import com.ebmwebsourcing.easyschema10.api.with.WithBlock;
import com.ebmwebsourcing.easyschema10.api.with.WithComplexType;
import com.ebmwebsourcing.easyschema10.api.with.WithDefault;
import com.ebmwebsourcing.easyschema10.api.with.WithFinal;
import com.ebmwebsourcing.easyschema10.api.with.WithForm;
import com.ebmwebsourcing.easyschema10.api.with.WithMinMaxOccurs;
import com.ebmwebsourcing.easyschema10.api.with.WithNillable;
import com.ebmwebsourcing.easyschema10.api.with.WithRef;
import com.ebmwebsourcing.easyschema10.api.with.WithSimpleType;

public interface Element extends SchemaXmlObject, WithId, WithOtherAttributes, WithAnnotation, WithName, WithRef, WithType,
        WithComplexType, WithSimpleType, WithDefault, WithNillable,
        WithAbstract, WithFinal, WithBlock, WithForm, WithMinMaxOccurs, WithInferrableQName {

    public static final QName QNAME = new QName(Constants.XMLSCHEMA_NS_URI,
            "element");
    public static final Element[] EMPTY_ARRAY = new Element[0];

    Type findType();
    
    Element findRef();
}
